/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines.jetty;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.InvocationCallback;
import jakarta.ws.rs.client.ResponseProcessingException;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.client.util.OutputStreamRequestContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.jboss.resteasy.client.jaxrs.engines.AsyncClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.engines.jetty.JettyClientResponse;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;

public class JettyClientEngine
implements AsyncClientHttpEngine {
    public static final String REQUEST_TIMEOUT_MS = JettyClientEngine.class + "$RequestTimeout";
    public static final String IDLE_TIMEOUT_MS = JettyClientEngine.class + "$IdleTimeout";
    public static final String FOLLOW_REDIRECTS = "jersey.config.client.followRedirects";
    private static final InvocationCallback<ClientResponse> NOP = new InvocationCallback<ClientResponse>(){

        public void completed(ClientResponse response) {
        }

        public void failed(Throwable throwable) {
        }
    };
    private final HttpClient client;

    public JettyClientEngine(HttpClient client) {
        if (!client.isStarted()) {
            try {
                client.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.client = client;
    }

    public SSLContext getSslContext() {
        return this.client.getSslContextFactory().getSslContext();
    }

    public HostnameVerifier getHostnameVerifier() {
        throw new UnsupportedOperationException();
    }

    public ClientResponse invoke(Invocation invocation) {
        Future<ClientResponse> future = this.submit((ClientInvocation)invocation, false, NOP, null);
        try {
            return future.get(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            future.cancel(true);
            Thread.currentThread().interrupt();
            throw JettyClientEngine.clientException(e, null);
        }
        catch (ExecutionException | TimeoutException e) {
            future.cancel(true);
            throw JettyClientEngine.clientException(e.getCause(), null);
        }
    }

    public <T> Future<T> submit(ClientInvocation invocation, boolean bufIn, InvocationCallback<T> callback, AsyncClientHttpEngine.ResultExtractor<T> extractor) {
        return this.doSubmit(invocation, bufIn, callback, extractor);
    }

    public <T> CompletableFuture<T> submit(ClientInvocation request, boolean buffered, AsyncClientHttpEngine.ResultExtractor<T> extractor, ExecutorService executorService) {
        return this.doSubmit(request, buffered, null, extractor);
    }

    private <T> CompletableFuture<T> doSubmit(final ClientInvocation invocation, final boolean buffered, final InvocationCallback<T> callback, final AsyncClientHttpEngine.ResultExtractor<T> extractor) {
        final ExecutorService asyncExecutor = invocation.asyncInvocationExecutor();
        Request request = this.client.newRequest(invocation.getUri());
        final RequestFuture future = new RequestFuture(request);
        invocation.getMutableProperties().forEach((arg_0, arg_1) -> ((Request)request).attribute(arg_0, arg_1));
        request.method(invocation.getMethod());
        request.headers(mutableHeaders -> invocation.getHeaders().asMap().forEach((h, vs) -> vs.forEach(v -> mutableHeaders.add(h, v))));
        this.configureTimeout(request);
        if (request.getAttributes().get(FOLLOW_REDIRECTS) == Boolean.FALSE) {
            request.followRedirects(false);
        }
        if (invocation.getEntity() != null) {
            OutputStreamRequestContent contentOut = new OutputStreamRequestContent(Objects.toString(invocation.getHeaders().getMediaType(), null));
            asyncExecutor.execute(() -> {
                block8: {
                    try (OutputStream bodyOut = contentOut.getOutputStream();){
                        invocation.writeRequestBody(bodyOut);
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                        if (callback == null) break block8;
                        callback.failed((Throwable)e);
                    }
                }
            });
            request.body((Request.Content)contentOut);
        }
        request.send((Response.CompleteListener)new InputStreamResponseListener(){
            private ClientResponse cr;

            public void onHeaders(org.eclipse.jetty.client.api.Response response) {
                super.onHeaders(response);
                InputStream inputStream = this.getInputStream();
                this.cr = new JettyClientResponse(invocation.getClientConfiguration(), inputStream);
                this.cr.setProperties(invocation.getMutableProperties());
                this.cr.setStatus(response.getStatus());
                this.cr.setHeaders(JettyClientEngine.this.extract(response.getHeaders()));
                asyncExecutor.submit(() -> {
                    try {
                        if (buffered) {
                            this.cr.bufferEntity();
                        }
                        this.complete(extractor == null ? this.cr : extractor.extractResult(this.cr));
                    }
                    catch (Exception e) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception e1) {
                            e.addSuppressed(e1);
                        }
                        this.onFailure(response, e);
                    }
                });
            }

            public void onFailure(org.eclipse.jetty.client.api.Response response, Throwable failure) {
                super.onFailure(response, failure);
                this.failed(failure);
            }

            private void complete(T result) {
                future.complete(result);
                if (callback != null) {
                    callback.completed(result);
                }
            }

            private void failed(Throwable t) {
                RuntimeException x = JettyClientEngine.clientException(t, (Response)this.cr);
                future.completeExceptionally(x);
                if (callback != null) {
                    callback.failed((Throwable)x);
                }
            }
        });
        return future;
    }

    private void configureTimeout(Request request) {
        Object timeout = request.getAttributes().get(REQUEST_TIMEOUT_MS);
        Object idleTimeout = request.getAttributes().get(IDLE_TIMEOUT_MS);
        long timeoutMs = this.parseTimeoutMs(timeout);
        long idleTimeoutMs = this.parseTimeoutMs(idleTimeout);
        if (timeoutMs > 0L) {
            request.timeout(timeoutMs, TimeUnit.MILLISECONDS);
        }
        if (idleTimeoutMs > 0L) {
            request.idleTimeout(idleTimeoutMs, TimeUnit.MILLISECONDS);
        }
    }

    private long parseTimeoutMs(Object timeout) {
        long timeoutMs = timeout instanceof Duration ? ((Duration)timeout).toMillis() : (timeout instanceof Number ? (long)((Number)timeout).intValue() : (timeout != null ? (long)Integer.parseInt(timeout.toString()) : -1L));
        return timeoutMs;
    }

    public void close() {
        try {
            this.client.stop();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to close JettyHttpEngine", e);
        }
    }

    MultivaluedMap<String, String> extract(HttpFields headers) {
        MultivaluedHashMap extracted = new MultivaluedHashMap();
        headers.forEach(arg_0 -> JettyClientEngine.lambda$extract$4((MultivaluedMap)extracted, arg_0));
        return extracted;
    }

    private static RuntimeException clientException(Throwable ex, Response clientResponse) {
        Object ret;
        if (ex == null) {
            NullPointerException e = new NullPointerException();
            e.fillInStackTrace();
            ret = new ProcessingException((Throwable)e);
        } else {
            ret = ex instanceof WebApplicationException ? (WebApplicationException)ex : (ex instanceof ProcessingException ? (ProcessingException)ex : (clientResponse != null ? new ResponseProcessingException(clientResponse, ex) : new ProcessingException(ex)));
        }
        ret.fillInStackTrace();
        return ret;
    }

    private static /* synthetic */ void lambda$extract$4(MultivaluedMap extracted, HttpField h) {
        extracted.add((Object)h.getName(), (Object)h.getValue());
    }

    static class RequestFuture<T>
    extends CompletableFuture<T> {
        private final Request request;

        RequestFuture(Request request) {
            this.request = request;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (mayInterruptIfRunning && cancelled) {
                this.request.abort((Throwable)new CancellationException());
            }
            return cancelled;
        }
    }
}

