/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines.jetty;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eclipse.jetty.client.util.DeferredContentProvider;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.Callback;
import org.jboss.resteasy.client.jaxrs.engines.jetty.ReleaseCallback;

class JettyContentStream
extends OutputStream {
    private static final int BUF_SIZE = 16384;
    private final ByteBufferPool bufs;
    private final DeferredContentProvider out;
    private ByteBuffer buf;

    JettyContentStream(ByteBufferPool bufs, DeferredContentProvider out) {
        this.bufs = bufs;
        this.out = out;
        this.buf = this.acquire();
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClose();
        if (!this.buf.hasRemaining()) {
            this.flush();
        }
        this.buf.put((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int rem) {
        this.checkClose();
        while (true) {
            if (!this.buf.hasRemaining() || rem == 0) {
                this.flush();
                return;
            }
            int r = Math.min(this.buf.remaining(), rem);
            this.buf.put(b, off, r);
            off += r;
            rem -= r;
            this.flush();
        }
    }

    @Override
    public void flush() {
        this.checkClose();
        this.buf.flip();
        if (this.buf.limit() == 0) {
            this.bufs.release(this.buf);
            return;
        }
        this.out.offer(this.buf, (Callback)new ReleaseCallback(this.bufs, this.buf));
        this.buf = this.acquire();
    }

    @Override
    public void close() throws IOException {
        if (this.buf != null) {
            this.flush();
            this.buf = null;
        }
    }

    private void checkClose() {
        if (this.out.isClosed()) {
            throw new IllegalStateException("closed");
        }
    }

    private ByteBuffer acquire() {
        ByteBuffer b = this.bufs.acquire(16384, false);
        b.limit(b.capacity());
        return b;
    }
}

