/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.ws.rs.WebApplicationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.resteasy.cdi.i18n.LogMessages;
import org.jboss.resteasy.cdi.i18n.Messages;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;

public class CdiConstructorInjector
implements ConstructorInjector {
    private BeanManager manager;
    private Type type;

    public CdiConstructorInjector(Type type, BeanManager manager) {
        this.type = type;
        this.manager = manager;
    }

    public Object construct(boolean unwrapAsync) {
        HashSet beans = this.manager.getBeans(this.type, new Annotation[0]);
        if (beans.size() > 1) {
            HashSet modifiableBeans = new HashSet();
            modifiableBeans.addAll(beans);
            Iterator iterator = modifiableBeans.iterator();
            while (iterator.hasNext()) {
                Bean bean = (Bean)iterator.next();
                if (bean.getBeanClass().equals(this.type) || bean.isAlternative()) continue;
                iterator.remove();
            }
            beans = modifiableBeans;
        }
        if (LogMessages.LOGGER.isDebugEnabled()) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.beansFound(this.type, beans));
        }
        Bean bean = this.manager.resolve((Set)beans);
        CreationalContext context = this.manager.createCreationalContext((Contextual)bean);
        return this.manager.getReference(bean, this.type, context);
    }

    public Object construct(HttpRequest request, HttpResponse response, boolean unwrapAsync) throws Failure, WebApplicationException, ApplicationException {
        return this.construct(unwrapAsync);
    }

    public Object injectableArguments(boolean unwrapAsync) {
        return null;
    }

    public Object injectableArguments(HttpRequest request, HttpResponse response, boolean unwrapAsync) throws Failure {
        return this.injectableArguments(unwrapAsync);
    }
}

