/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.enterprise.inject.spi.BeanManager;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;

public class Utils {
    public static boolean isJaxrsAnnotatedClass(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Path.class)) {
            return true;
        }
        if (clazz.isAnnotationPresent(Provider.class)) {
            return true;
        }
        for (Method method : clazz.getMethods()) {
            if (method.isAnnotationPresent(Path.class)) {
                return true;
            }
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(HttpMethod.class)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isJaxrsResource(Class<?> clazz) {
        if (Utils.isJaxrsAnnotatedClass(clazz)) {
            return true;
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            if (!Utils.isJaxrsAnnotatedClass(intf)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJaxrsComponent(Class<?> clazz) {
        return clazz.isAnnotationPresent(Provider.class) || Utils.isJaxrsResource(clazz) || Application.class.isAssignableFrom(clazz);
    }

    public static boolean isScopeDefined(Class<?> clazz, BeanManager manager) {
        for (Annotation annotation : clazz.getAnnotations()) {
            if (manager.isScope(annotation.annotationType())) {
                return true;
            }
            if (!manager.isStereotype(annotation.annotationType()) || !Utils.isScopeDefined(annotation.annotationType(), manager)) continue;
            return true;
        }
        return false;
    }
}

