/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.ws.rs.WebApplicationException;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdiConstructorInjector
implements ConstructorInjector {
    private BeanManager manager;
    private Class<?> clazz;
    private static final Logger log = LoggerFactory.getLogger(CdiConstructorInjector.class);

    public CdiConstructorInjector(Class<?> clazz, BeanManager manager) {
        this.clazz = clazz;
        this.manager = manager;
    }

    public Object construct() {
        HashSet beans = this.manager.getBeans(this.clazz, new Annotation[0]);
        if (beans.size() > 1) {
            HashSet modifiableBeans = new HashSet();
            modifiableBeans.addAll(beans);
            Iterator iterator = modifiableBeans.iterator();
            while (iterator.hasNext()) {
                Bean bean = (Bean)iterator.next();
                if (bean.getBeanClass().equals(this.clazz) || bean.isAlternative()) continue;
                iterator.remove();
            }
            beans = modifiableBeans;
        }
        log.debug("Beans found for class {} : {}", (Object)this.clazz.getCanonicalName(), (Object)beans);
        Bean bean = this.manager.resolve((Set)beans);
        CreationalContext context = this.manager.createCreationalContext((Contextual)bean);
        return this.manager.getReference(bean, this.clazz, context);
    }

    public Object construct(HttpRequest request, HttpResponse response) throws Failure, WebApplicationException, ApplicationException {
        return this.construct();
    }

    public Object[] injectableArguments() {
        return new Object[0];
    }

    public Object[] injectableArguments(HttpRequest request, HttpResponse response) throws Failure {
        return this.injectableArguments();
    }
}

