/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessSessionBean;
import javax.enterprise.util.AnnotationLiteral;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.cdi.JaxrsAnnotatedType;
import org.jboss.resteasy.cdi.JaxrsInjectionTarget;
import org.jboss.resteasy.cdi.Utils;
import org.jboss.resteasy.util.GetRestful;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResteasyCdiExtension
implements Extension {
    private final Logger log = LoggerFactory.getLogger(ResteasyCdiExtension.class);
    public static final Annotation requestScopedLiteral = new AnnotationLiteral<RequestScoped>(){
        private static final long serialVersionUID = 3381824686081435817L;
    };
    public static final Annotation applicationScopedLiteral = new AnnotationLiteral<ApplicationScoped>(){
        private static final long serialVersionUID = -8211157243671012820L;
    };
    private Map<Class<?>, Class<?>> sessionBeanInterface = new HashMap();

    public <T> void observeResources(@Observes ProcessAnnotatedType<T> event) {
        AnnotatedType type = event.getAnnotatedType();
        if (!type.getJavaClass().isInterface()) {
            if (type.isAnnotationPresent(Provider.class)) {
                this.log.debug("Discovered CDI bean which is a JAX-RS provider {}.", (Object)type.getJavaClass().getCanonicalName());
                event.setAnnotatedType(this.wrapAnnotatedType(type, applicationScopedLiteral));
            } else if (GetRestful.isRootResource((Class)type.getJavaClass())) {
                this.log.debug("Discovered CDI bean which is a JAX-RS resource {}.", (Object)type.getJavaClass().getCanonicalName());
                event.setAnnotatedType(this.wrapAnnotatedType(type, requestScopedLiteral));
            } else if (Application.class.isAssignableFrom(type.getJavaClass())) {
                this.log.debug("Discovered CDI bean which is javax.ws.rs.core.Application subclass {}.", (Object)type.getJavaClass().getCanonicalName());
                event.setAnnotatedType(this.wrapAnnotatedType(type, applicationScopedLiteral));
            }
        }
    }

    protected <T> AnnotatedType<T> wrapAnnotatedType(AnnotatedType<T> type, Annotation scope) {
        if (Utils.isScopeDefined(type.getJavaClass())) {
            this.log.debug("Bean {} has a scope defined.", (Object)type.getJavaClass());
            return type;
        }
        this.log.debug("Bean {} does not have the scope defined. Binding to {}.", (Object)type.getJavaClass(), (Object)scope);
        return new JaxrsAnnotatedType<T>(type, scope);
    }

    public <T> void observeInjectionTarget(@Observes ProcessInjectionTarget<T> event) {
        if (event.getAnnotatedType() == null) {
            this.log.warn("ProcessInjectionTarget.getAnnotatedType() returned null. As a result, JAX-RS property injection will not work.");
            return;
        }
        if (Utils.isJaxrsComponent(event.getAnnotatedType().getJavaClass())) {
            event.setInjectionTarget(this.wrapInjectionTarget(event));
        }
    }

    protected <T> InjectionTarget<T> wrapInjectionTarget(ProcessInjectionTarget<T> event) {
        return new JaxrsInjectionTarget(event.getInjectionTarget(), event.getAnnotatedType().getJavaClass());
    }

    public <T> void observeSessionBeans(@Observes ProcessSessionBean<T> event) {
        Bean sessionBean = event.getBean();
        if (Utils.isJaxrsComponent(sessionBean.getBeanClass())) {
            this.addSessionBeanInterface(sessionBean);
        }
    }

    private void addSessionBeanInterface(Bean<?> bean) {
        for (Type type : bean.getTypes()) {
            Class clazz;
            if (!(type instanceof Class) || !((Class)type).isInterface() || !Utils.isJaxrsAnnotatedClass(clazz = (Class)type)) continue;
            this.sessionBeanInterface.put(bean.getBeanClass(), (Class)type);
            this.log.debug("{} local interface will be used for {} lookup", (Object)type, (Object)bean.getBeanClass());
            return;
        }
        this.log.debug("No lookup interface found for {}", (Object)bean.getBeanClass());
    }

    public Map<Class<?>, Class<?>> getSessionBeanInterface() {
        return this.sessionBeanInterface;
    }
}

