/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.injection;

import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.inject.Inject;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.jboss.resteasy.cdi.injection.Book;
import org.jboss.resteasy.cdi.injection.BookCollection;
import org.jboss.resteasy.cdi.injection.BookResource;
import org.jboss.resteasy.cdi.util.Counter;

@MessageDriven(name="BookMDB", activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/test")})
public class BookMDB
implements MessageListener {
    @Inject
    private Logger log;
    @Inject
    private BookResource resource;

    public void onMessage(Message arg0) {
        TextMessage tm = (TextMessage)TextMessage.class.cast(arg0);
        try {
            this.log.info(this + ": msg: " + tm.getText());
            BookCollection collection = this.resource.getBookCollection();
            this.log.info(this + ": collection.size() before: " + collection.getBooks().size());
            Counter counter = this.resource.getCounter();
            collection.addBook(new Book(counter.getNext(), tm.getText()));
            this.log.info(this + ": collection.size() after: " + collection.getBooks().size());
            CountDownLatch latch = this.resource.getCountDownLatch();
            latch.countDown();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }
}

