/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.generic;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.cdi.generic.HierarchyHolder;
import org.jboss.resteasy.cdi.generic.HolderBinding;
import org.jboss.resteasy.cdi.generic.Primate;
import org.jboss.resteasy.cdi.generic.UpperBoundHierarchyHolder;
import org.jboss.resteasy.cdi.generic.UpperBoundTypedResourceIntf;
import org.jboss.resteasy.cdi.generic.VisitList;

@Path(value="upperbound")
@Dependent
public class UpperBoundTypedResource<T extends HierarchyHolder<? extends Primate>>
implements UpperBoundTypedResourceIntf<T> {
    @Inject
    private Logger log;
    @Inject
    @HolderBinding
    private UpperBoundHierarchyHolder<T> typeParameterUpperBound;
    private Class<?> clazz;

    public UpperBoundTypedResource() {
        System.out.println("UpperBoundTypedResource<?>(): " + this);
    }

    public UpperBoundTypedResource(Class<?> clazz) {
        this.clazz = clazz;
        System.out.println("UpperBoundTypedResource(" + clazz + "): " + this);
    }

    public Type getTypeArgument() {
        return this.clazz;
    }

    @Override
    @GET
    @Path(value="injection")
    public Response testGenerics() {
        this.log.info("entering UpperBoundTypedResource.testGenerics()");
        this.log.info(this.typeParameterUpperBound.getTypeArgument().toString());
        boolean result = true;
        if (!this.typeParameterUpperBound.getTypeArgument().equals(Primate.class)) {
            this.log.info("typeParameterUpperBound type argument class should be Primate instead of " + this.typeParameterUpperBound.getTypeArgument());
            result = false;
        }
        return result ? Response.ok().build() : Response.serverError().build();
    }

    @Override
    @GET
    @Path(value="decorators/clear")
    public Response clear() {
        this.log.info("entering UpperBoundTypedResource.clear()");
        VisitList.clear();
        return Response.ok().build();
    }

    @Override
    @GET
    @Path(value="decorators/execute")
    public Response execute() {
        this.log.info("entering UpperBoundTypedResource.execute()");
        return Response.ok().build();
    }

    @Override
    @GET
    @Path(value="decorators/test")
    public Response testDecorators() {
        int i;
        boolean status;
        this.log.info("entering UpperBoundTypedResource.testDecorators()");
        ArrayList<String> expectedList = new ArrayList<String>();
        expectedList.add("upperBoundDecoratorEnter");
        expectedList.add("upperBoundDecoratorLeave");
        ArrayList<String> visitList = VisitList.getList();
        boolean bl = status = expectedList.size() == visitList.size();
        if (!status) {
            this.log.info("expectedList.size() [" + expectedList.size() + "] != visitList.size() [" + visitList.size() + "]");
        } else {
            for (i = 0; i < expectedList.size(); ++i) {
                if (((String)expectedList.get(i)).equals(visitList.get(i))) continue;
                status = false;
                this.log.info("visitList.get(" + i + ") incorrect: should be: " + (String)expectedList.get(i) + ", is: " + visitList.get(i));
                break;
            }
        }
        if (!status) {
            this.log.info("\rexpectedList: ");
            for (i = 0; i < expectedList.size(); ++i) {
                this.log.info(i + ": " + ((String)expectedList.get(i)).toString());
            }
            this.log.info("\rvisitList:");
            for (i = 0; i < visitList.size(); ++i) {
                this.log.info(i + ": " + visitList.get(i).toString());
            }
        }
        return status ? Response.ok().build() : Response.serverError().build();
    }
}

