/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.extension.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.cdi.util.Utilities;

public class BostonBean<T>
implements Bean<T> {
    @Inject
    Logger log;
    private Class<T> clazz;
    private String className;
    private InjectionTarget<T> injectionTarget;
    private Set<Type> types;
    private Set<Annotation> qualifiers;
    private Class<? extends Annotation> scope;
    private Set<InjectionPoint> injectionPoints;

    public BostonBean(Class<T> clazz, InjectionTarget<T> injectionTarget) {
        this.clazz = clazz;
        this.className = clazz.getSimpleName();
        this.injectionTarget = injectionTarget;
        this.types = Utilities.getTypeClosure(clazz);
        this.qualifiers = Utilities.getQualifiers(clazz);
        this.injectionPoints = injectionTarget.getInjectionPoints();
        this.scope = Utilities.getScopeAnnotation(clazz);
        if (this.scope == null) {
            this.scope = Utilities.isAnnotationPresent(clazz, Path.class) ? RequestScoped.class : (Utilities.isAnnotationPresent(clazz, Provider.class) ? ApplicationScoped.class : RequestScoped.class);
        }
    }

    public T create(CreationalContext<T> creationalContext) {
        System.out.println("BostonBean[" + this.className + "].create()");
        Object instance = this.injectionTarget.produce(creationalContext);
        System.out.println("BostonBean[" + this.className + "].create() raw instance: " + instance);
        this.injectionTarget.inject(instance, creationalContext);
        this.injectionTarget.postConstruct(instance);
        System.out.println("BostonBean[" + this.className + "].create(): cooked instance: " + instance);
        return (T)instance;
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
        System.out.println("BostonBean[" + this.className + "].destroy()");
        creationalContext.release();
    }

    public Set<Type> getTypes() {
        System.out.println("BostonBean[" + this.className + "].getTypes()");
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        System.out.println("BostonBean[" + this.className + "].getQualifiers()");
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        System.out.println("BostonBean[" + this.className + "].getScope()");
        return this.scope;
    }

    public String getName() {
        System.out.println("BostonBean[" + this.className + "].getName()");
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        System.out.println("BostonBean[" + this.className + "].getStereotypes()");
        return new HashSet<Class<? extends Annotation>>();
    }

    public Class<?> getBeanClass() {
        System.out.println("BostonBean[" + this.className + "].getBeanClass()");
        return this.clazz;
    }

    public boolean isAlternative() {
        System.out.println("BostonBean[" + this.className + "].isAlternative()");
        return false;
    }

    public boolean isNullable() {
        System.out.println("BostonBean[" + this.className + "].isNullable()");
        return false;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        System.out.println("BostonBean[" + this.className + "].getInjectionPoints()");
        return this.injectionPoints;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BostonBean[").append(this.clazz).append('\r').append("            scope: ").append(this.scope).append('\r').append("            types: ");
        Iterator<Type> it1 = this.types.iterator();
        while (it1.hasNext()) {
            sb.append(it1.next()).append('\r').append("                   ");
        }
        sb.append('\r').append("       qualifiers: ");
        Iterator<Annotation> it2 = this.qualifiers.iterator();
        while (it2.hasNext()) {
            sb.append(it2.next()).append('\r').append("                   ");
        }
        sb.append('\r').append(" injection points: ");
        Iterator<InjectionPoint> it3 = this.getInjectionPoints().iterator();
        while (it3.hasNext()) {
            sb.append(it3.next()).append('\r').append("                   ");
        }
        sb.append('\r').append("]");
        return sb.toString();
    }
}

