/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi.decorators;

import java.util.logging.Logger;
import javax.decorator.Decorator;
import javax.decorator.Delegate;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.cdi.decorators.Book;
import org.jboss.resteasy.cdi.decorators.TestResource;
import org.jboss.resteasy.cdi.decorators.TestResourceIntf;
import org.jboss.resteasy.cdi.decorators.VisitList;

@Decorator
public abstract class ResourceDecorator
implements TestResourceIntf {
    @Inject
    private Logger log;
    @Inject
    @Delegate
    private TestResource resource;

    @Override
    public Response createBook(Book book) {
        this.log.info("entering ResourceDecorator.createBook()");
        VisitList.add("resourceDecoratorEnter");
        Response response = this.resource.createBook(book);
        VisitList.add("resourceDecoratorLeave");
        this.log.info("leaving ResourceDecorator.createBook()");
        return response;
    }

    @Override
    public Book lookupBookById(int id) {
        this.log.info("entering ResourceDecorator.lookupBookById()");
        VisitList.add("resourceDecoratorEnter");
        Book book = this.resource.lookupBookById(id);
        VisitList.add("resourceDecoratorLeave");
        this.log.info("leaving ResourceDecorator.lookupBookById()");
        return book;
    }

    @Override
    public abstract Response test();
}

