/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.jws;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.jose.Base64Url;
import org.jboss.resteasy.jose.i18n.Messages;
import org.jboss.resteasy.jose.jws.JWSHeader;

public class JWSInput {
    String wireString;
    String encodedHeader;
    String encodedContent;
    String encodedSignature;
    JWSHeader header;
    Providers providers;
    byte[] content;
    byte[] signature;
    private static ObjectMapper mapper = new ObjectMapper();

    public JWSInput(String wire) {
        this(wire, null);
    }

    public JWSInput(String wire, Providers providers) {
        this.providers = providers;
        this.wireString = wire;
        String[] parts = wire.split("\\.");
        if (parts.length < 2 || parts.length > 3) {
            throw new IllegalArgumentException(Messages.MESSAGES.parsingError());
        }
        this.encodedHeader = parts[0];
        this.encodedContent = parts[1];
        try {
            this.content = Base64Url.decode(this.encodedContent);
            if (parts.length > 2) {
                this.encodedSignature = parts[2];
                this.signature = Base64Url.decode(this.encodedSignature);
            }
            byte[] headerBytes = Base64Url.decode(this.encodedHeader);
            this.header = (JWSHeader)mapper.readValue(headerBytes, JWSHeader.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getWireString() {
        return this.wireString;
    }

    public String getEncodedHeader() {
        return this.encodedHeader;
    }

    public String getEncodedContent() {
        return this.encodedContent;
    }

    public String getEncodedSignature() {
        return this.encodedSignature;
    }

    public JWSHeader getHeader() {
        return this.header;
    }

    public byte[] getContent() {
        return this.content;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public <T> T readContent(Class<T> type) {
        MediaType mediaType = MediaType.WILDCARD_TYPE;
        if (this.header.getContentType() != null) {
            mediaType = MediaType.valueOf((String)this.header.getContentType());
        }
        return (T)this.readContent(type, null, null, mediaType);
    }

    public Object readContent(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MessageBodyReader reader = this.providers.getMessageBodyReader(type, genericType, annotations, mediaType);
        if (reader == null) {
            throw new RuntimeException(Messages.MESSAGES.unableToFindReaderForContentType());
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.content);
            return reader.readFrom(type, genericType, annotations, mediaType, (MultivaluedMap)new MultivaluedHashMap(), (InputStream)bais);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

