/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.jwe.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class HMAC {
    HMAC() {
    }

    public static byte[] compute(String alg, byte[] secret, byte[] message) throws RuntimeException {
        return HMAC.compute(new SecretKeySpec(secret, alg), message);
    }

    public static byte[] compute(SecretKey secretKey, byte[] message) throws RuntimeException {
        Mac mac;
        try {
            mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unsupported HMAC algorithm: " + e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Invalid HMAC key: " + e.getMessage(), e);
        }
        mac.update(message);
        return mac.doFinal();
    }
}

