/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.jwe.crypto;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class CompositeKey {
    private final SecretKey inputKey;
    private final SecretKey macKey;
    private final SecretKey encKey;
    private final int truncatedMacLength;

    public CompositeKey(SecretKey inputKey) throws RuntimeException {
        this.inputKey = inputKey;
        byte[] secretKeyBytes = inputKey.getEncoded();
        if (secretKeyBytes.length == 32) {
            this.macKey = new SecretKeySpec(secretKeyBytes, 0, 16, "HMACSHA256");
            this.encKey = new SecretKeySpec(secretKeyBytes, 16, 16, "AES");
            this.truncatedMacLength = 16;
        } else if (secretKeyBytes.length == 64) {
            this.macKey = new SecretKeySpec(secretKeyBytes, 0, 32, "HMACSHA512");
            this.encKey = new SecretKeySpec(secretKeyBytes, 32, 32, "AES");
            this.truncatedMacLength = 32;
        } else {
            throw new RuntimeException("Unsupported AES/CBC/PKCS5Padding/HMAC-SHA2 key length, must be 256 or 512 bits");
        }
    }

    public SecretKey getInputKey() {
        return this.inputKey;
    }

    public SecretKey getMACKey() {
        return this.macKey;
    }

    public int getTruncatedMACByteLength() {
        return this.truncatedMacLength;
    }

    public SecretKey getAESKey() {
        return this.encKey;
    }
}

