/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.json;

import java.util.Collection;
import se.unlogic.standardutils.json.JsonArray;
import se.unlogic.standardutils.json.JsonLeaf;
import se.unlogic.standardutils.json.JsonNode;
import se.unlogic.standardutils.json.JsonObject;
import se.unlogic.standardutils.validation.ValidationError;

public class JsonUtils {
    private static final String CONTENT_TYPE = "application/json";

    public static JsonNode encode(Collection<ValidationError> validationErrors) {
        JsonArray jsonArray = new JsonArray();
        for (ValidationError error : validationErrors) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.putField("field", new JsonLeaf(error.getFieldName()));
            jsonObject.putField("errorType", new JsonLeaf(error.getValidationErrorType().toString()));
            jsonObject.putField("messageKey", new JsonLeaf(error.getMessageKey()));
            jsonArray.addNode(jsonObject);
        }
        return jsonArray;
    }

    public static String getContentType() {
        return CONTENT_TYPE;
    }
}

