/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import se.unlogic.standardutils.callback.Callback;
import se.unlogic.standardutils.streams.StreamUtils;

public class FileUtils {
    public static String toAsciiFilename(String string) {
        return string.replaceAll("[^0-9a-zA-Z-.]", "_");
    }

    public static String toValidHttpFilename(String string) {
        return string.replaceAll("[^0-9a-\u00f6A-\u00d6-+. ()-+!@\u00e9&%$\u00a7=\u00b4]", "_");
    }

    public static final byte[] getRawBytes(File f) throws IOException {
        FileInputStream fin = new FileInputStream(f);
        byte[] buffer = new byte[(int)f.length()];
        fin.read(buffer);
        fin.close();
        return buffer;
    }

    public static String getFileExtension(File file) {
        return FileUtils.getFileExtension(file.getName());
    }

    public static String getFileExtension(String filename) {
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex == -1 || dotIndex + 1 == filename.length()) {
            return null;
        }
        return filename.substring(dotIndex + 1);
    }

    public static boolean fileExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static int deleteFiles(String directory, FileFilter filter, boolean recursive) {
        return FileUtils.deleteFiles(new File(directory), filter, recursive);
    }

    public static int deleteFiles(File dir, FileFilter filter, boolean recursive) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files;
            int deletedFiles = 0;
            for (File file : files = dir.listFiles(filter)) {
                if (file.isDirectory()) {
                    if (!recursive) continue;
                    deletedFiles += FileUtils.deleteFiles(file, filter, recursive);
                    continue;
                }
                if (!file.delete()) continue;
                ++deletedFiles;
            }
            return deletedFiles;
        }
        return 0;
    }

    public static int replace(File dir, String filename, File replacementFile, boolean recursive, boolean caseSensitive, Callback<File> callback) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files;
            int replacedFiles = 0;
            for (File file : files = dir.listFiles()) {
                if (file.isDirectory()) {
                    if (!recursive) continue;
                    replacedFiles += FileUtils.replace(file, filename, replacementFile, recursive, caseSensitive, callback);
                    continue;
                }
                if ((!caseSensitive ? !file.getName().equalsIgnoreCase(filename) : !file.getName().equals(filename)) || !file.canWrite()) continue;
                try {
                    if (callback != null) {
                        callback.callback(file);
                    }
                    FileUtils.replaceFile(file, replacementFile);
                    ++replacedFiles;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return replacedFiles;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceFile(File target, File replacement) throws IOException {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(replacement);
            outputStream = new FileOutputStream(target);
            inputStream.getChannel().transferTo(0L, replacement.length(), outputStream.getChannel());
            StreamUtils.transfer(inputStream, outputStream);
        }
        catch (Throwable throwable) {
            StreamUtils.closeStream(inputStream);
            StreamUtils.closeStream(outputStream);
            throw throwable;
        }
        StreamUtils.closeStream(inputStream);
        StreamUtils.closeStream(outputStream);
    }

    public static boolean deleteDirectory(String directoryPath) {
        return FileUtils.deleteDirectory(new File(directoryPath));
    }

    public static boolean deleteDirectory(File directory) {
        if (directory.exists()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                if (file.isDirectory()) {
                    FileUtils.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return directory.delete();
    }

    public static void deleteFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }
}

