/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.exec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import se.unlogic.standardutils.exec.StreamHandler;
import se.unlogic.standardutils.readwrite.ReadWriteUtils;

public class StreamPrinter
extends Thread
implements StreamHandler {
    private InputStream inputStream;
    private String prefix;
    private OutputStream outputStream;
    private boolean terminated = false;

    public StreamPrinter(String prefix, OutputStream os) {
        this.outputStream = os;
        this.prefix = prefix;
    }

    public StreamPrinter(OutputStream os) {
        this.outputStream = os;
    }

    public StreamPrinter() {
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public void terminate() {
        this.terminated = true;
    }

    @Override
    public void run() {
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            PrintWriter pw = null;
            pw = this.outputStream != null ? new PrintWriter(this.outputStream) : new PrintWriter(System.out);
            inputStreamReader = new InputStreamReader(this.inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            String line = null;
            if (this.prefix != null) {
                while (!this.terminated && (line = bufferedReader.readLine()) != null) {
                    pw.println(this.prefix + line);
                }
            } else {
                while (!this.terminated && (line = bufferedReader.readLine()) != null) {
                    pw.println(line);
                }
            }
            if (pw != null) {
                pw.flush();
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                ReadWriteUtils.closeReader(bufferedReader);
                ReadWriteUtils.closeReader(inputStreamReader);
                this.terminated = true;
                throw throwable;
            }
        }
        ReadWriteUtils.closeReader(bufferedReader);
        ReadWriteUtils.closeReader(inputStreamReader);
        this.terminated = true;
    }

    @Override
    public void handleStream(InputStream is) {
        this.inputStream = is;
        this.start();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public boolean isFinished() {
        return !this.isAlive();
    }

    @Override
    public void awaitFinish() {
        try {
            this.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

