/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.dao.querys;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import se.unlogic.standardutils.dao.BeanResultSetPopulator;
import se.unlogic.standardutils.dao.querys.PopulatedQuery;
import se.unlogic.standardutils.db.DBUtils;

public class ArrayListQuery<ReturnType>
extends PopulatedQuery<ReturnType> {
    public ArrayListQuery(Connection connection, boolean closeConnectionOnExit, String query, BeanResultSetPopulator<ReturnType> bp) throws SQLException {
        super(connection, closeConnectionOnExit, query, bp);
    }

    public ArrayListQuery(DataSource dataSource, boolean closeConnectionOnExit, String query, BeanResultSetPopulator<ReturnType> bp) throws SQLException {
        super(dataSource, closeConnectionOnExit, query, bp);
    }

    public ArrayList<ReturnType> executeQuery() throws SQLException {
        ResultSet rs = null;
        ArrayList returnTypeList = null;
        try {
            rs = this.pstmt.executeQuery();
            if (rs.next()) {
                rs.last();
                returnTypeList = new ArrayList(rs.getRow());
                rs.beforeFirst();
                while (rs.next()) {
                    returnTypeList.add(this.beanPopulator.populate(rs));
                }
            }
            ArrayList arrayList = returnTypeList;
            return arrayList;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        finally {
            DBUtils.closeResultSet(rs);
            DBUtils.closePreparedStatement(this.pstmt);
            if (this.closeConnectionOnExit) {
                DBUtils.closeConnection(this.connection);
            }
            this.closed = true;
        }
    }

    @Override
    protected PreparedStatement getPreparedStatement(String query) throws SQLException {
        return this.connection.prepareStatement(query, 1004, 1007);
    }
}

