/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CollectionUtils {
    public static <T> List<T> getGenericList(Class<T> clazz, int size) {
        return new ArrayList(size);
    }

    public static <T> List<T> getGenericList(Class<T> clazz) {
        return new ArrayList();
    }

    public static <T> List<T> getGenericSingletonList(T bean) {
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(bean);
        return list;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> List<T> conjunction(Collection<T> c1, Collection<T> c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>(c1.size());
        for (T o : c1) {
            if (!c2.contains(o)) continue;
            result.add(o);
        }
        return result;
    }

    public static <T> Collection<T> exclusiveDisjunction(Collection<T> c1, Collection<T> c2) {
        ArrayList<T> result = new ArrayList<T>();
        if (c1 == null && c2 == null) {
            return result;
        }
        if (c1 == null && c2 != null) {
            return c2;
        }
        if (c1 != null && c2 == null) {
            return c1;
        }
        for (T o : c1) {
            if (c2.contains(o)) continue;
            result.add(o);
        }
        return result;
    }

    public static <T> List<T> getList(T ... objects) {
        return Arrays.asList(objects);
    }

    public static void removeNullValues(List<?> list) {
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (value != null) continue;
            iterator.remove();
        }
    }

    public static int getSize(Collection<?> collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }
}

