/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.operation;

import se.unlogic.standardutils.time.TimeUtils;

public class ProgressMeter {
    private long start;
    private long finish;
    private long currentPosition;
    private long startTime;
    private long endTime;

    public ProgressMeter() {
    }

    public ProgressMeter(long start, long finish) {
        this.start = start;
        this.finish = finish;
    }

    public ProgressMeter(boolean setStartTime) {
        if (setStartTime) {
            this.setStartTime();
        }
    }

    public ProgressMeter(int start, int finish, int currentPosition) {
        this.start = start;
        this.finish = finish;
        this.currentPosition = currentPosition;
    }

    public long getCurrentPosition() {
        return this.currentPosition;
    }

    public synchronized void setCurrentPosition(int currentPosition) {
        this.currentPosition = currentPosition;
    }

    public synchronized void incrementCurrentPosition() {
        ++this.currentPosition;
    }

    public synchronized void decrementCurrentPosition() {
        --this.currentPosition;
    }

    public long getFinish() {
        return this.finish;
    }

    public void setFinish(long finish) {
        this.finish = finish;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public int getPercentComplete() {
        if (this.finish > this.start) {
            return (int)((float)(this.currentPosition - this.start) / (float)(this.finish - this.start) * 100.0f);
        }
        if (this.finish < this.start) {
            return (int)((float)(this.start - this.currentPosition) / (float)(this.start - this.finish) * 100.0f);
        }
        return -1;
    }

    public int getPercentRemaining() {
        if (this.finish > this.start) {
            if (this.finish - this.currentPosition != 0L) {
                return (int)((float)(this.finish - this.currentPosition) / (float)(this.finish - this.start) * 100.0f);
            }
            return 0;
        }
        if (this.finish < this.start) {
            if (this.currentPosition - this.finish != 0L) {
                return (int)((float)(this.currentPosition - this.finish) / (float)(this.start - this.finish) * 100.0f);
            }
            return 0;
        }
        return -1;
    }

    public long getIntervalSize() {
        if (this.finish > this.start) {
            return this.finish - this.start;
        }
        if (this.finish < this.start) {
            return this.start - this.finish;
        }
        return 0L;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime() {
        this.endTime = System.currentTimeMillis();
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getTimeSpent() {
        if (this.startTime != 0L) {
            if (this.endTime == 0L) {
                return System.currentTimeMillis() - this.startTime;
            }
            return this.endTime - this.startTime;
        }
        return 0L;
    }

    public void incrementCurrentPosition(long value) {
        this.currentPosition += value;
    }

    public String getTimeSpentString() {
        return TimeUtils.millisecondsToString(this.getTimeSpent());
    }
}

