/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.test;

import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.jboss.resteasy.test.annotations.FollowUpRequired;

@SupportedOptions(value={"dev.resteasy.test.follow.up.level"})
public class FollowUpRequiredProcessor
extends AbstractProcessor {
    private final Set<String> supportedAnnotations = Set.of(FollowUpRequired.class.getName());

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver() && !annotations.isEmpty()) {
            Diagnostic.Kind kind;
            Messager messager = this.processingEnv.getMessager();
            String kindLevel = this.processingEnv.getOptions().getOrDefault("dev.resteasy.test.follow.up.level", "WARNING");
            try {
                kind = Diagnostic.Kind.valueOf(kindLevel);
            }
            catch (IllegalArgumentException e) {
                kind = Diagnostic.Kind.WARNING;
                messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Failed to parse follow-up level " + kindLevel + ". Defaulting to " + kind + ".");
            }
            for (TypeElement typeElement : annotations) {
                Set<? extends Element> annotated = roundEnv.getElementsAnnotatedWith(typeElement);
                for (Element element : annotated) {
                    String msg = element.getAnnotation(FollowUpRequired.class).value();
                    messager.printMessage(kind, "Follow up required: " + msg, element);
                }
            }
        }
        return true;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return this.supportedAnnotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }
}

