/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.extension.systemproperties.client;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.lang.reflect.ReflectPermission;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.Set;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.resteasy.utils.TestConfiguration;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.wildfly.testing.tools.deployments.DeploymentDescriptors;

public class ArchiveProcessor
implements ApplicationArchiveProcessor {
    @Inject
    private Instance<ArquillianDescriptor> descriptor;

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        String prefix = this.getPrefix();
        if (prefix != null && applicationArchive instanceof ResourceContainer) {
            ResourceContainer container = (ResourceContainer)applicationArchive;
            container.addAsResource((Asset)new StringAsset(this.toString(this.filterSystemProperties(prefix))), "arq_system.properties");
        }
        if (TestConfiguration.isSecurityManagerEnabled()) {
            Asset permissionsXml;
            String jbossHome = ArchiveProcessor.resolveJBossHome();
            Set<PropertyPermission> requirePermissions = Set.of(new FilePermission(jbossHome + "*", "read"), new FilePermission(jbossHome + "modules" + File.separatorChar + "-", "read"), new ReflectPermission("suppressAccessChecks"), new RuntimePermission("accessDeclaredMembers"), new RuntimePermission("accessClassInPackage.sun.reflect.annotation"), new PropertyPermission("arquillian.*", "read"), new PropertyPermission("module.path", "read"), new PropertyPermission("jboss.home.*", "read"), new PropertyPermission("junit.platform.reflection.search.useLegacySemantics", "read"));
            Node node = applicationArchive.delete("/META-INF/permissions.xml");
            if (node != null) {
                Asset currentPermissions = node.getAsset();
                permissionsXml = DeploymentDescriptors.appendPermissions((Asset)currentPermissions, requirePermissions);
            } else {
                permissionsXml = DeploymentDescriptors.createPermissionsXmlAsset(requirePermissions);
            }
            applicationArchive.add(permissionsXml, "/META-INF/permissions.xml");
        }
    }

    private String getPrefix() {
        return this.getConfiguration().get("prefix");
    }

    private Map<String, String> getConfiguration() {
        for (ExtensionDef def : ((ArquillianDescriptor)this.descriptor.get()).getExtensions()) {
            if (!"systemproperties".equalsIgnoreCase(def.getExtensionName())) continue;
            return def.getExtensionProperties();
        }
        return new HashMap<String, String>();
    }

    private Properties filterSystemProperties(String prefix) {
        Properties filteredProps = new Properties();
        Properties sysProps = System.getProperties();
        for (Map.Entry<Object, Object> entry : sysProps.entrySet()) {
            if (!entry.getKey().toString().startsWith(prefix)) continue;
            filteredProps.put(entry.getKey(), entry.getValue());
        }
        return filteredProps;
    }

    private String toString(Properties props) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            props.store(out, "Arquillian SystemProperties Extension");
            return out.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not store properties", e);
        }
    }

    private static String resolveJBossHome() {
        String value = System.getProperty("jboss.home");
        String jbossHome = value == null ? "target/server" : value;
        if (jbossHome.endsWith("/") || jbossHome.endsWith("\\")) {
            return jbossHome;
        }
        return jbossHome + File.separatorChar;
    }
}

