/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.setup;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.resteasy.utils.TestUtil;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public abstract class AbstractUsersRolesSecurityDomainSetup
implements ServerSetupTask {
    private static final String USERS_FILENAME = "users.properties";
    private static final String ROLES_FILENAME = "roles.properties";
    private final URL userFile;
    private final URL rolesFile;
    private final Deque<Address> toRemove;
    private final Queue<Path> filesToRemove;

    protected AbstractUsersRolesSecurityDomainSetup(URL userFile, URL rolesFile) {
        this.userFile = userFile;
        this.rolesFile = rolesFile;
        this.toRemove = new LinkedList<Address>();
        this.filesToRemove = new ArrayDeque<Path>();
    }

    public void setup(ManagementClient client, String s) throws Exception {
        Operations ops = new Operations(TestUtil.clientInit());
        ModelNodeResult result = ops.invoke("path-info", Address.of((String)"path", (String)"jboss.server.config.dir"));
        result.assertSuccess("Failed to resolve the jboss.server.config.dir");
        Path configDir = Paths.get(result.value().get(new String[]{"path", "resolved-path"}).asString(), new String[0]);
        this.filesToRemove.add(this.createPropertiesFile(this.userFile, configDir.resolve(USERS_FILENAME)));
        this.filesToRemove.add(this.createPropertiesFile(this.rolesFile, configDir.resolve(ROLES_FILENAME)));
        Batch batch = new Batch();
        for (Map.Entry<String, String> entry : this.getSecurityDomainConfig().entrySet()) {
            String domainName = entry.getKey();
            String realmName = entry.getValue();
            Address propertiesRealmAddress = Address.subsystem((String)"elytron").and("properties-realm", realmName);
            batch.add(propertiesRealmAddress, Values.empty().andObject("users-properties", Values.empty().and("path", USERS_FILENAME).and("relative-to", "jboss.server.config.dir").and("plain-text", true)).andObjectOptional("groups-properties", Values.empty().and("path", ROLES_FILENAME).and("relative-to", "jboss.server.config.dir")));
            this.toRemove.addLast(propertiesRealmAddress);
            Address securityDomainAddress = Address.subsystem((String)"elytron").and("security-domain", domainName);
            ModelNode realms = new ModelNode().setEmptyObject();
            realms.get("realm").set(realmName);
            realms.get("role-decoder").set("groups-to-roles");
            batch.add(securityDomainAddress, Values.ofList((String)"realms", (ModelNode[])new ModelNode[]{realms}).and("default-realm", realmName).and("permission-mapper", "default-permission-mapper"));
            this.toRemove.addFirst(securityDomainAddress);
            Address httpAuthAddress = Address.subsystem((String)"elytron").and("http-authentication-factory", "http-auth-" + domainName);
            ModelNode mechanismConfigs = new ModelNode().setEmptyObject();
            mechanismConfigs.get("mechanism-name").set("BASIC");
            ModelNode mechanisms = mechanismConfigs.get("mechanism-realm-configurations").setEmptyList();
            ModelNode mechanismsValue = new ModelNode().setEmptyObject();
            mechanismsValue.get("realm-name").set("\"Property Elytron\"");
            mechanisms.add(mechanismsValue);
            batch.add(httpAuthAddress, Values.empty().and("http-server-mechanism-factory", "global").and("security-domain", domainName).andList("mechanism-configurations", new ModelNode[]{mechanismConfigs}));
            this.toRemove.addFirst(httpAuthAddress);
            Address undertowAppSecDomainAddress = Address.subsystem((String)"undertow").and("application-security-domain", domainName);
            batch.add(undertowAppSecDomainAddress, Values.of((String)"http-authentication-factory", (String)httpAuthAddress.getLastPairValue()));
            this.toRemove.addFirst(undertowAppSecDomainAddress);
        }
        ops.batch(batch).assertSuccess("Failed to configure Elytron");
    }

    public void tearDown(ManagementClient client, String s) throws Exception {
        Path file;
        Address address;
        OnlineManagementClient managementClient = TestUtil.clientInit();
        Administration administration = new Administration(managementClient);
        Operations ops = new Operations(managementClient);
        Batch batch = new Batch();
        while ((address = this.toRemove.pollFirst()) != null) {
            batch.remove(address);
        }
        ops.batch(batch).assertSuccess("Failed to remove the Elytron config");
        while ((file = this.filesToRemove.poll()) != null) {
            Files.deleteIfExists(file);
        }
        administration.reloadIfRequired();
    }

    public Map<String, String> getSecurityDomainConfig() {
        return Collections.singletonMap("jaxrsSecDomain", "propRealm");
    }

    private Path createPropertiesFile(URL url, Path file) throws IOException {
        if (url != null) {
            try (InputStream in = url.openStream();){
                Files.copy(in, file, StandardCopyOption.REPLACE_EXISTING);
            }
        } else if (Files.notExists(file, new LinkOption[0])) {
            Files.createFile(file, new FileAttribute[0]);
        }
        return file;
    }
}

