/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Application;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.resteasy.api.validation.ResteasyConstraintViolation;
import org.jboss.resteasy.api.validation.ResteasyViolationException;
import org.jboss.resteasy.api.validation.ViolationReport;
import org.jboss.resteasy.utils.PortProviderUtil;
import org.jboss.resteasy.utils.TestApplication;
import org.jboss.resteasy.utils.maven.MavenUtil;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.wildfly.extras.creaper.core.ManagementClient;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.OnlineOptions;

public class TestUtil {
    protected static Logger logger;
    private static String baseResourcePath;
    private static final boolean MODULAR_JVM;

    public static WebArchive prepareArchive(String deploymentName) {
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)(deploymentName + ".war"));
        war.addClass(TestApplication.class);
        return war;
    }

    public static WebArchive prepareArchiveWithApplication(String deploymentName, Class<? extends Application> clazz) {
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)(deploymentName + ".war"));
        war.addClass(clazz);
        return war;
    }

    public static Archive<?> finishContainerPrepare(WebArchive war, Map<String, String> contextParams, Class<?> ... resources) {
        return TestUtil.finishContainerPrepare(war, contextParams, null, resources);
    }

    public static Archive<?> finishContainerPrepare(WebArchive war, Map<String, String> contextParams, List<Class<?>> singletons, Class<?> ... resources) {
        if (contextParams == null) {
            contextParams = new Hashtable<String, String>();
        }
        HashSet<String> classNamesInDeployment = new HashSet<String>();
        HashSet<String> singletonsNamesInDeployment = new HashSet<String>();
        if (resources != null) {
            for (Class<?> clazz : resources) {
                war.addClass((Class)clazz);
                classNamesInDeployment.add(clazz.getTypeName());
            }
        }
        if (singletons != null) {
            for (Class clazz : singletons) {
                war.addClass(clazz);
                singletonsNamesInDeployment.add(clazz.getTypeName());
            }
        }
        if (contextParams != null && contextParams.size() > 0 && !war.contains("WEB-INF/web.xml")) {
            StringBuilder webXml = new StringBuilder();
            webXml.append("<web-app version=\"3.0\" xmlns=\"http://java.sun.com/xml/ns/javaee\" \n");
            webXml.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n");
            webXml.append(" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd\"> \n");
            for (Map.Entry<String, String> entry : contextParams.entrySet()) {
                String string = entry.getKey();
                String paramValue = entry.getValue();
                logger.info("Context param " + string + " value " + paramValue);
                webXml.append("<context-param>\n");
                webXml.append("<param-name>" + string + "</param-name>\n");
                webXml.append("<param-value>" + paramValue + "</param-value>\n");
                webXml.append("</context-param>\n");
            }
            webXml.append("</web-app>\n");
            StringAsset stringAsset = new StringAsset(webXml.toString());
            war.addAsWebInfResource((Asset)stringAsset, "web.xml");
        }
        StringBuilder classes = new StringBuilder();
        boolean bl = true;
        for (String string : classNamesInDeployment) {
            boolean bl2;
            if (bl2) {
                bl2 = false;
            } else {
                classes.append(",");
            }
            classes.append(string);
        }
        war.addAsResource((Asset)new StringAsset(classes.toString()), "classes.txt");
        StringBuilder singletonBuilder = new StringBuilder();
        boolean bl3 = true;
        for (String clazz : singletonsNamesInDeployment) {
            boolean bl4;
            if (bl4) {
                bl4 = false;
            } else {
                singletonBuilder.append(",");
            }
            singletonBuilder.append(clazz);
        }
        war.addAsResource((Asset)new StringAsset(singletonBuilder.toString()), "singletons.txt");
        if (System.getProperty("STORE_WAR") != null) {
            ((ZipExporter)war.as(ZipExporter.class)).exportTo(new File("target", war.getName()), true);
        }
        return war;
    }

    public static String getManagementHost() {
        return System.getProperty("wildfly.management.host", PortProviderUtil.getHost());
    }

    public static int getManagementPort() {
        return Integer.parseInt(System.getProperty("wildfly.management.port", "9990"));
    }

    public static int getManagementPort(int offset) {
        return TestUtil.getManagementPort() + offset;
    }

    public static OnlineManagementClient clientInit() throws IOException {
        OnlineOptions onlineOptions = OnlineOptions.standalone().hostAndPort(PortProviderUtil.getHost(), TestUtil.getManagementPort()).connectionTimeout(120000).build();
        return ManagementClient.online((OnlineOptions)onlineOptions);
    }

    public static OnlineManagementClient clientInit(int portOffset) throws IOException {
        OnlineOptions onlineOptions = OnlineOptions.standalone().hostAndPort("localhost", TestUtil.getManagementPort(portOffset)).connectionTimeout(120000).build();
        return ManagementClient.online((OnlineOptions)onlineOptions);
    }

    public static ModelNodeResult runCmd(OnlineManagementClient client, String cmd) throws Exception {
        ModelNodeResult result = client.execute(cmd);
        logger.info("CLI command: " + cmd);
        logger.info("Result: " + result.toString());
        return result;
    }

    protected WebArchive addPackageInfo(WebArchive war, Class<?> clazz) {
        return (WebArchive)war.addPackages(false, (Filter)new Filter<ArchivePath>(){

            public boolean include(ArchivePath path) {
                return path.get().endsWith("package-info.class");
            }
        }, new Package[]{clazz.getPackage()});
    }

    public static String readString(InputStream in) throws IOException {
        char[] buffer = new char[1024];
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        int wasRead = 0;
        do {
            if ((wasRead = reader.read(buffer, 0, 1024)) <= 0) continue;
            builder.append(buffer, 0, wasRead);
        } while (wasRead > -1);
        return builder.toString();
    }

    public static String getErrorMessageForKnownIssue(String jira, String message) {
        StringBuilder s = new StringBuilder();
        s.append("https://issues.jboss.org/browse/");
        s.append(jira);
        s.append(" - ");
        s.append(message);
        return s.toString();
    }

    public static String getErrorMessageForKnownIssue(String jira) {
        return TestUtil.getErrorMessageForKnownIssue(jira, "known issue");
    }

    public static String getJbossHome() {
        return System.getProperty("jboss.home");
    }

    public static String getJbossHome(boolean onServer) {
        if (!onServer) {
            return TestUtil.getJbossHome();
        }
        return System.getProperty("jboss.home.dir", "");
    }

    public static String getStandaloneDir(String containerQualifier) {
        return TestUtil.getStandaloneDir(false, containerQualifier);
    }

    public static String getStandaloneDir(boolean onServer, String containerQualifier) {
        if (!onServer) {
            if (containerQualifier == null) {
                return new File(TestUtil.getJbossHome(), "standalone").getAbsolutePath();
            }
            return new File("target", containerQualifier).getAbsolutePath();
        }
        return System.getProperty("jboss.server.base.dir", "");
    }

    public static boolean isOpenJDK() {
        return System.getProperty("java.runtime.name").toLowerCase().contains("openjdk");
    }

    public static boolean isWildFly9x() {
        String sv = System.getProperty("server.version");
        return "9.0.2.Final".equals(sv) || "9.0.1.Final".equals(sv) || "9.0.0.Final".equals(sv);
    }

    public static boolean isOracleJDK() {
        if (TestUtil.isOpenJDK()) {
            return false;
        }
        String vendor = System.getProperty("java.vendor").toLowerCase();
        return vendor.contains("sun") || vendor.contains("oracle");
    }

    public static boolean isIbmJdk() {
        return System.getProperty("java.vendor").toLowerCase().contains("ibm");
    }

    public static boolean isModularJvm() {
        return MODULAR_JVM;
    }

    public static String getResourcePath(Class<?> c, String name) {
        return baseResourcePath + c.getPackage().getName().replace('.', File.separatorChar) + File.separator + name;
    }

    public static List<String> readServerLogLines() {
        return TestUtil.readServerLogLines(false);
    }

    public static List<String> readServerLogLines(boolean onServer) {
        return TestUtil.readServerLogLines(onServer, null);
    }

    public static List<String> readServerLogLines(boolean onServer, String containerQualifier) {
        String standaloneDir = TestUtil.getStandaloneDir(onServer, containerQualifier);
        String logPath = String.format("%s%slog%sserver.log", standaloneDir, standaloneDir.endsWith(File.separator) || standaloneDir.endsWith("/") ? "" : File.separator, File.separator);
        logPath = logPath.replace('/', File.separatorChar);
        try {
            return Files.readAllLines(Paths.get(logPath, new String[0]));
        }
        catch (MalformedInputException e1) {
            try {
                return Files.readAllLines(Paths.get(logPath, new String[0]), StandardCharsets.ISO_8859_1);
            }
            catch (IOException e4) {
                throw new RuntimeException("Server logs has not standard Charsets (UTF8 or ISO_8859_1)");
            }
        }
        catch (IOException iOException) {
            return new ArrayList<String>();
        }
    }

    public static int getWarningCount(String findedString, boolean onServer) {
        return TestUtil.getWarningCount(findedString, onServer, null);
    }

    public static int getWarningCount(String findedString, boolean onServer, String containerQualifier) {
        return TestUtil.getWarningCount(findedString, onServer, containerQualifier, false);
    }

    public static int getWarningCount(String findedString, boolean onServer, String containerQualifier, boolean useRegexp) {
        int count = 0;
        List<String> lines = TestUtil.readServerLogLines(onServer, containerQualifier);
        for (String line : lines) {
            if ((useRegexp || !line.contains(findedString)) && (!useRegexp || !line.matches(findedString))) continue;
            ++count;
        }
        return count;
    }

    public static void countViolations(ResteasyViolationException e, int totalCount, int propertyCount, int classCount, int parameterCount, int returnValueCount) {
        Assert.assertEquals((String)"Different total count of violations expected", (long)totalCount, (long)e.getViolations().size());
        Assert.assertEquals((String)"Different count of property violations expected", (long)propertyCount, (long)e.getPropertyViolations().size());
        Assert.assertEquals((String)"Different count of class violations expected", (long)classCount, (long)e.getClassViolations().size());
        Assert.assertEquals((String)"Different count of parameter violations expected", (long)parameterCount, (long)e.getParameterViolations().size());
        Assert.assertEquals((String)"Different count of return value violations expected", (long)returnValueCount, (long)e.getReturnValueViolations().size());
    }

    public static void countViolations(ViolationReport e, int propertyCount, int classCount, int parameterCount, int returnValueCount) {
        Assert.assertEquals((String)"Different count of property violations expected", (long)propertyCount, (long)e.getPropertyViolations().size());
        Assert.assertEquals((String)"Different count of class violations expected", (long)classCount, (long)e.getClassViolations().size());
        Assert.assertEquals((long)parameterCount, (long)e.getParameterViolations().size());
        Assert.assertEquals((long)returnValueCount, (long)e.getReturnValueViolations().size());
    }

    public static ResteasyConstraintViolation getViolationByMessage(List<ResteasyConstraintViolation> list, String message) {
        for (ResteasyConstraintViolation v : list) {
            if (!v.getMessage().contains(message)) continue;
            return v;
        }
        return null;
    }

    public static ResteasyConstraintViolation getViolationByMessageAndValue(List<ResteasyConstraintViolation> list, String message, Object value) {
        for (ResteasyConstraintViolation v : list) {
            if (!v.getMessage().contains(message) || !v.getValue().equals(value)) continue;
            return v;
        }
        return null;
    }

    public static ResteasyConstraintViolation getViolationByPath(List<ResteasyConstraintViolation> list, String path) {
        for (ResteasyConstraintViolation v : list) {
            if (!v.getPath().contains(path)) continue;
            return v;
        }
        return null;
    }

    public static File resolveDependency(String dependency) {
        File mavenGav;
        MavenUtil mavenUtil = MavenUtil.create(true);
        try {
            mavenGav = mavenUtil.createMavenGavFile(dependency);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get artifacts from maven via Aether library", e);
        }
        return mavenGav;
    }

    public static void addOtherLibrary(WebArchive archive, String dependency) {
        archive.addAsLibrary(TestUtil.resolveDependency(dependency));
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            Assert.fail((String)"Can't get the operating system name");
        }
        return osName.indexOf("Windows") > -1 || osName.indexOf("windows") > -1;
    }

    static {
        Matcher matcher;
        baseResourcePath = "src" + File.separator + "test" + File.separator + "resources" + File.separator;
        try {
            logger = LogManager.getLogger((String)TestUtil.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        String javaSpecVersion = System.getProperty("java.specification.version");
        boolean modularJvm = false;
        if (javaSpecVersion != null && (matcher = Pattern.compile("^(?:1\\.)?(\\d+)$").matcher(javaSpecVersion)).find()) {
            modularJvm = Integer.parseInt(matcher.group(1)) >= 9;
        }
        MODULAR_JVM = modularJvm;
    }
}

