/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.jboss.remotingjmx.RemotingConnectorServer;
import org.jboss.remotingjmx.Util;
import org.jboss.remotingjmx.VersionedConectionFactory;
import org.jboss.remotingjmx.VersionedConnection;
import org.xnio.IoFuture;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Property;
import org.xnio.Sequence;
import org.xnio.Xnio;

class RemotingConnector
implements JMXConnector {
    private static final Logger log = Logger.getLogger(RemotingConnectorServer.class);
    private final JMXServiceURL serviceUrl;
    private final Map<String, ?> environment;
    private Endpoint endpoint;
    private Connection connection;
    private boolean closed = false;
    private Channel channel;
    private VersionedConnection versionedConnection;
    private ShutDownHook shutDownHook;

    RemotingConnector(JMXServiceURL serviceURL, Map<String, ?> environment) throws IOException {
        this.serviceUrl = serviceURL;
        this.environment = Collections.unmodifiableMap(environment);
    }

    @Override
    public void connect() throws IOException {
        this.connect(null);
    }

    @Override
    public void connect(Map<String, ?> env) throws IOException {
        try {
            this.internalConnect(env);
        }
        catch (Exception e) {
            this.close();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    private void internalConnect(Map<String, ?> env) throws IOException {
        IoFuture futureConnection;
        IoFuture.Status result;
        if (this.closed) {
            throw new IOException("Connector already closed.");
        }
        Xnio xnio = Xnio.getInstance();
        this.endpoint = Remoting.createEndpoint((String)"endpoint", (Xnio)xnio, (OptionMap)OptionMap.create((Option)Options.THREAD_DAEMON, (Object)true));
        this.endpoint.addConnectionProvider("remote", (ConnectionProviderFactory)new RemoteConnectionProviderFactory(), OptionMap.EMPTY);
        if (log.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer("connect(");
            if (env != null) {
                for (String key : env.keySet()) {
                    Object current = env.get(key);
                    if (current instanceof String[]) {
                        String[] temp = (String[])current;
                        StringBuffer sb2 = new StringBuffer();
                        sb2.append("[username=").append(temp[0]).append(",password=").append(temp[1]).append("]");
                        current = sb2;
                    }
                    sb.append("{").append(key).append(",").append(String.valueOf(current)).append("}");
                }
            } else {
                sb.append("null");
            }
            sb.append(")");
            log.trace((Object)sb.toString());
        }
        HashMap combinedEnvironment = new HashMap(this.environment);
        if (env != null) {
            for (String key : env.keySet()) {
                combinedEnvironment.put(key, env.get(key));
            }
        }
        CallbackHandler handler = null;
        if (env != null && (handler = (CallbackHandler)env.get(CallbackHandler.class.getName())) == null && env.containsKey("jmx.remote.credentials")) {
            handler = new UsernamePasswordCallbackHandler((String[])env.get("jmx.remote.credentials"));
        }
        if (handler == null) {
            handler = new AnonymousCallbackHandler();
        }
        if ((result = (futureConnection = this.endpoint.connect(Util.convert(this.serviceUrl), this.getOptionMap(), handler)).await(5L, TimeUnit.SECONDS)) != IoFuture.Status.DONE) {
            if (result == IoFuture.Status.FAILED) {
                throw futureConnection.getException();
            }
            throw new RuntimeException("Operation failed with status " + result);
        }
        this.connection = (Connection)futureConnection.get();
        String serviceName = this.serviceUrl.getURLPath();
        if (serviceName.length() == 0) {
            serviceName = "jmx";
        } else if (serviceName.startsWith("/") || serviceName.startsWith(";")) {
            serviceName = serviceName.substring(1);
        }
        IoFuture futureChannel = this.connection.openChannel(serviceName, OptionMap.EMPTY);
        result = futureChannel.await(5L, TimeUnit.SECONDS);
        if (result != IoFuture.Status.DONE) {
            if (result == IoFuture.Status.FAILED) {
                throw new IOException(futureChannel.getException());
            }
            throw new RuntimeException("Operation failed with status " + result);
        }
        this.channel = (Channel)futureChannel.get();
        this.versionedConnection = VersionedConectionFactory.createVersionedConnection(this.channel, env);
        this.shutDownHook = new ShutDownHook();
        Runtime.getRuntime().addShutdownHook(this.shutDownHook);
    }

    private OptionMap getOptionMap() {
        OptionMap.Builder builder = OptionMap.builder();
        builder.set(Options.SASL_POLICY_NOANONYMOUS, (Object)Boolean.FALSE);
        builder.set(Options.SASL_POLICY_NOPLAINTEXT, (Object)Boolean.FALSE);
        ArrayList<Property> tempProperties = new ArrayList<Property>(1);
        tempProperties.add(Property.of((String)"jboss.sasl.local-user.quiet-auth", (String)"true"));
        builder.set(Options.SASL_PROPERTIES, (Object)Sequence.of(tempProperties));
        builder.set(Options.SSL_ENABLED, true);
        builder.set(Options.SSL_STARTTLS, true);
        return builder.getMap();
    }

    private void verifyConnected() throws IOException {
        if (this.closed) {
            throw new IOException("Connector already closed.");
        }
        if (this.versionedConnection == null) {
            throw new IOException("Connector not connected.");
        }
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        log.trace((Object)"getMBeanServerConnection()");
        return this.getMBeanServerConnection(null);
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(Subject delegationSubject) throws IOException {
        log.trace((Object)"getMBeanServerConnection(Subject)");
        this.verifyConnected();
        return this.versionedConnection.getMBeanServerConnection(delegationSubject);
    }

    @Override
    public void close() throws IOException {
        log.trace((Object)"close()");
        this.closed = true;
        ShutDownHook shutDownHook = this.shutDownHook;
        if (shutDownHook != null) {
            Runtime.getRuntime().removeShutdownHook(shutDownHook);
            this.shutDownHook = null;
        }
        this.safeClose(this.versionedConnection);
        this.safeClose(this.channel);
        this.safeClose((Closeable)this.connection);
        this.safeClose((Closeable)this.endpoint);
    }

    private void safeClose(Channel channel) {
        if (channel != null) {
            try {
                channel.writeShutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.safeClose((Closeable)channel);
    }

    private void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        log.trace((Object)"addConnectionNotificationListener()");
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        log.trace((Object)"removeConnectionNotificationListener()");
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener l, NotificationFilter f, Object handback) throws ListenerNotFoundException {
        log.trace((Object)"removeConnectionNotificationListener()");
    }

    @Override
    public String getConnectionId() throws IOException {
        log.trace((Object)"getConnectionId()");
        this.verifyConnected();
        String connectionId = this.versionedConnection.getConnectionId();
        log.debugf("Our connection id is '%s'", (Object)connectionId);
        return connectionId;
    }

    private class ShutDownHook
    extends Thread {
        private ShutDownHook() {
            super(new Runnable(){

                @Override
                public void run() {
                    if (!RemotingConnector.this.closed) {
                        try {
                            RemotingConnector.this.shutDownHook = null;
                            RemotingConnector.this.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    private class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private final String[] credentials;

        private UsernamePasswordCallbackHandler(String[] credentials) {
            this.credentials = credentials;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.credentials[0]);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(this.credentials[1].toCharArray());
                    continue;
                }
                if (current instanceof RealmCallback) {
                    RealmCallback realmCallback = (RealmCallback)current;
                    realmCallback.setText(realmCallback.getDefaultText());
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }

    private class AnonymousCallbackHandler
    implements CallbackHandler {
        private AnonymousCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (!(current instanceof NameCallback)) {
                    throw new UnsupportedCallbackException(current);
                }
                NameCallback ncb = (NameCallback)current;
                ncb.setName("anonymous");
            }
        }
    }
}

