/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remotingjmx.Constants;
import org.jboss.remotingjmx.Version;
import org.jboss.remotingjmx.VersionedProxy;
import org.jboss.remotingjmx.protocol.CancellableDataOutputStream;
import org.jboss.remotingjmx.protocol.Versions;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class RemotingConnectorServer
extends JMXConnectorServer {
    private static final Logger log = Logger.getLogger(RemotingConnectorServer.class);
    private boolean started = false;
    private boolean stopped = false;
    private Endpoint endpoint;
    private Registration registration;
    private Executor executor;

    public RemotingConnectorServer(MBeanServer mbeanServer, Endpoint endpoint) {
        this(mbeanServer, endpoint, Executors.newCachedThreadPool());
    }

    public RemotingConnectorServer(MBeanServer mbeanServer, Endpoint endpoint, Executor executor) {
        super(mbeanServer);
        this.endpoint = endpoint;
        this.executor = executor;
    }

    @Override
    public void start() throws IOException {
        log.trace((Object)"start()");
        if (this.stopped) {
            throw new IOException("Unable to start connector as already stopped.");
        }
        if (this.started) {
            return;
        }
        log.trace((Object)"Registering service");
        this.registration = this.endpoint.registerService("jmx", (OpenListener)new ChannelOpenListener(), OptionMap.EMPTY);
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        if (this.stopped) {
            return;
        }
        try {
            if (this.started) {
                this.registration.close();
            }
        }
        finally {
            this.endpoint = null;
            this.registration = null;
            this.stopped = true;
        }
    }

    @Override
    public boolean isActive() {
        return this.started && !this.stopped;
    }

    @Override
    public JMXServiceURL getAddress() {
        return null;
    }

    @Override
    public Map<String, ?> getAttributes() {
        return Collections.emptyMap();
    }

    public void connectionOpened(VersionedProxy proxy) {
        String connectionId = proxy.getConnectionId();
        log.debugf("Connection '%s' now opened.", (Object)connectionId);
        this.connectionOpened(connectionId, "", null);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    private void writeHeader(Channel channel) throws IOException {
        CancellableDataOutputStream dos = new CancellableDataOutputStream(channel.writeMessage());
        try {
            dos.writeBytes("JMX");
            byte[] versions = Versions.getSupportedVersions();
            dos.writeInt(versions.length);
            dos.write(versions);
            if (Version.isSnapshot()) {
                dos.write(1);
            } else {
                dos.write(0);
            }
        }
        catch (IOException e) {
            dos.cancel();
            throw e;
        }
        finally {
            dos.close();
        }
    }

    private class ClientVersionReceiver
    implements Channel.Receiver {
        private ClientVersionReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Channel channel, MessageInputStream messageInputStream) {
            DataInputStream dis = new DataInputStream((InputStream)messageInputStream);
            try {
                log.tracef("Bytes Available %d", (Object)dis.available());
                byte[] firstThree = new byte[3];
                dis.read(firstThree);
                log.tracef("First Three %s", (Object)new String(firstThree));
                if (!Arrays.equals(firstThree, Constants.JMX)) {
                    throw new IOException("Invalid leading bytes in header.");
                }
                log.tracef("Bytes Available %d", (Object)dis.available());
                byte version = dis.readByte();
                log.debugf("Chosen version 0x0%d", (Object)version);
                Versions.getVersionedProxy(version, channel, RemotingConnectorServer.this);
            }
            catch (IOException e) {
                log.error((Object)"Error determining version selected by client.");
            }
            finally {
                IoUtils.safeClose((Closeable)dis);
            }
        }

        public void handleError(Channel channel, IOException e) {
            log.warn((Object)"Error on channel before fully established.", (Throwable)e);
        }

        public void handleEnd(Channel channel) {
        }
    }

    private class ChannelOpenListener
    implements OpenListener {
        private ChannelOpenListener() {
        }

        public void channelOpened(Channel channel) {
            log.trace((Object)"Channel Opened");
            try {
                RemotingConnectorServer.this.writeHeader(channel);
                channel.receiveMessage((Channel.Receiver)new ClientVersionReceiver());
            }
            catch (IOException e) {
                log.error((Object)"Unable to send header, closing channel", (Throwable)e);
                IoUtils.safeClose((Closeable)channel);
            }
        }

        public void registrationTerminated() {
        }
    }
}

