/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.serialization.impl.java;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.logging.Logger;
import org.jboss.remoting.util.SecurityUtility;

public class ClearableObjectOutputStream
extends ObjectOutputStream {
    protected static Logger log = Logger.getLogger((Class)ClearableObjectOutputStream.class);
    protected static Method clearMethod;
    protected static Object[] PARAMS;

    public ClearableObjectOutputStream(OutputStream out) throws IOException {
        super(out);
    }

    public void clear() {
        try {
            clearMethod.invoke((Object)this, PARAMS);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    private static Method getDeclaredMethod(final Class c, final String name, final Class[] parameterTypes) throws NoSuchMethodException {
        if (SecurityUtility.skipAccessControl()) {
            Method m = c.getDeclaredMethod(name, parameterTypes);
            m.setAccessible(true);
            return m;
        }
        try {
            return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    Method m = c.getDeclaredMethod(name, parameterTypes);
                    m.setAccessible(true);
                    return m;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NoSuchMethodException)e.getCause();
        }
    }

    static {
        PARAMS = new Object[0];
        try {
            clearMethod = ClearableObjectOutputStream.getDeclaredMethod(ObjectOutputStream.class, "clear", new Class[0]);
        }
        catch (SecurityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

