/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.callback;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.CallbackErrorHandler;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
import org.jboss.remoting.util.SecurityUtility;

public class CallbackErrorHandlerWrapper
implements CallbackErrorHandler {
    private CallbackErrorHandler proxy;

    public CallbackErrorHandlerWrapper(CallbackErrorHandler proxy) {
        this.proxy = proxy;
    }

    public void handleError(final Throwable ex) throws Throwable {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.handleError(ex);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    try {
                        CallbackErrorHandlerWrapper.this.proxy.handleError(ex);
                        return null;
                    }
                    catch (Throwable e) {
                        throw new Exception(ex);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause.getCause() == null) {
                throw cause;
            }
            throw cause.getCause();
        }
    }

    public void setCallbackHandler(final ServerInvokerCallbackHandler serverInvokerCallbackHandler) {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.setCallbackHandler(serverInvokerCallbackHandler);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CallbackErrorHandlerWrapper.this.proxy.setCallbackHandler(serverInvokerCallbackHandler);
                return null;
            }
        });
    }

    public void setConfig(final Map errorHandlerConfig) {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.setConfig(errorHandlerConfig);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CallbackErrorHandlerWrapper.this.proxy.setConfig(errorHandlerConfig);
                return null;
            }
        });
    }

    public void setServerInvoker(final ServerInvoker owner) {
        if (SecurityUtility.skipAccessControl()) {
            this.proxy.setServerInvoker(owner);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CallbackErrorHandlerWrapper.this.proxy.setServerInvoker(owner);
                return null;
            }
        });
    }
}

