/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.loading;

import org.jboss.logging.Logger;
import org.jboss.remoting.serialization.ClassLoaderUtility;

public class RemotingClassLoader
extends ClassLoader {
    private ClassLoader userClassLoader = null;
    private int referenceCounter;
    private boolean parentFirstDelegation;
    protected static final Logger log = Logger.getLogger((Class)RemotingClassLoader.class);
    protected static final boolean isTrace = log.isTraceEnabled();

    public RemotingClassLoader(ClassLoader remotingClassLoader, ClassLoader userClassLoader) {
        this(remotingClassLoader, userClassLoader, true);
    }

    public RemotingClassLoader(ClassLoader remotingClassLoader, ClassLoader userClassLoader, boolean parentFirstDelegation) {
        super(remotingClassLoader);
        this.userClassLoader = userClassLoader;
        this.parentFirstDelegation = parentFirstDelegation;
        this.referenceCounter = 1;
    }

    public void setUserClassLoader(ClassLoader userClassLoader) throws Exception {
        if (this.userClassLoader == null) {
            this.userClassLoader = userClassLoader;
        } else if (this.userClassLoader != userClassLoader) {
            throw new Exception("Attempting to change existing userClassLoader");
        }
        ++this.referenceCounter;
    }

    public void unsetUserClassLoader() {
        if (--this.referenceCounter == 0) {
            this.userClassLoader = null;
        }
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class loadedClass = null;
        ClassLoader parent = this.getParent();
        loadedClass = this.parentFirstDelegation || this.userClassLoader == null ? this.loadClassDelegate(name, parent, this.userClassLoader) : this.loadClassDelegate(name, this.userClassLoader, parent);
        if (loadedClass == null) {
            loadedClass = ClassLoaderUtility.loadClass(name, this.getClass());
        }
        return loadedClass;
    }

    private Class loadClassDelegate(String name, ClassLoader primary, ClassLoader secondary) throws ClassNotFoundException {
        Class<?> loadedClass;
        block5: {
            loadedClass = null;
            try {
                loadedClass = Class.forName(name, false, primary);
            }
            catch (ClassNotFoundException e) {
                if (isTrace) {
                    log.trace((Object)("Could not load class (" + name + ") using primary class loader (" + primary + ")"));
                }
                if (secondary == null) break block5;
                try {
                    loadedClass = Class.forName(name, false, secondary);
                }
                catch (ClassNotFoundException e1) {
                    if (!isTrace) break block5;
                    log.trace((Object)("Could not load class (" + name + ") using secondary class loader (" + secondary + ")"));
                }
            }
        }
        return loadedClass;
    }
}

