/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.net.ServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.AbstractInvoker;
import org.jboss.remoting.ClientHolder;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.ConnectionNotifier;
import org.jboss.remoting.Home;
import org.jboss.remoting.InvalidConfigurationException;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.Lease;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvokerMBean;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
import org.jboss.remoting.invocation.InternalInvocation;
import org.jboss.remoting.invocation.OnewayInvocation;
import org.jboss.remoting.loading.ClassBytes;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.security.ServerSocketFactoryMBean;
import org.jboss.remoting.security.ServerSocketFactoryWrapper;
import org.jboss.remoting.serialization.ClassLoaderUtility;
import org.jboss.remoting.socketfactory.CreationListenerServerSocketFactory;
import org.jboss.remoting.socketfactory.SocketCreationListener;
import org.jboss.remoting.stream.StreamHandler;
import org.jboss.remoting.stream.StreamInvocationHandler;
import org.jboss.remoting.transport.PortUtil;
import org.jboss.remoting.util.SecurityUtility;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.BlockingMode;
import org.jboss.util.threadpool.ThreadPool;
import org.jboss.util.threadpool.ThreadPoolMBean;

public abstract class ServerInvoker
extends AbstractInvoker
implements ServerInvokerMBean {
    protected static final Logger log = Logger.getLogger((Class)ServerInvoker.class);
    public static final String MAX_NUM_ONEWAY_THREADS_KEY = "maxNumThreadsOneway";
    public static final String ONEWAY_THREAD_POOL_CLASS_KEY = "onewayThreadPool";
    public static final String SERVER_BIND_ADDRESS_KEY = "serverBindAddress";
    public static final String CLIENT_CONNECT_ADDRESS_KEY = "clientConnectAddress";
    public static final String SERVER_BIND_PORT_KEY = "serverBindPort";
    public static final String CLIENT_CONNECT_PORT_KEY = "clientConnectPort";
    public static final String CLIENT_LEASE_PERIOD = "clientLeasePeriod";
    public static final String TIMEOUT = "timeout";
    public static final String SERVER_SOCKET_FACTORY = "serverSocketFactory";
    public static final int MAX_NUM_ONEWAY_THREADS = 100;
    public static final String MAX_ONEWAY_THREAD_POOL_QUEUE_SIZE = "maxOnewayThreadPoolQueueSize";
    public static final int DEFAULT_CLIENT_LEASE_PERIOD = 5000;
    public static final int DEFAULT_TIMEOUT_PERIOD = 60000;
    public static final String BLOCKING_MODE = "blockingMode";
    public static final String BLOCKING_TIMEOUT = "blockingTimeout";
    public static final String BLOCKING = "blocking";
    public static final String NONBLOCKING = "nonblocking";
    public static final int DEFAULT_BLOCKING_TIMEOUT = 5000;
    public static final String REGISTER_CALLBACK_LISTENER = "registerCallbackListener";
    public static final String ECHO = "$ECHO$";
    public static final String INVOKER_SESSION_ID = "invokerSessionId";
    public static final String CONNECTION_LISTENER = "connectionListener";
    private static boolean trace = log.isTraceEnabled();
    private int maxNumberThreads = 100;
    private int maxOnewayThreadPoolQueueSize = -1;
    private String onewayThreadPoolClass = null;
    private ThreadPool onewayThreadPool;
    private Object onewayThreadPoolLock = new Object();
    private boolean created = false;
    private MBeanServer mbeanServer = null;
    private String dataType;
    private String serverBindAddress = null;
    private int serverBindPort = 0;
    private String clientConnectAddress = null;
    private int clientConnectPort = -1;
    protected List connectHomes = new ArrayList();
    protected List homes = new ArrayList();
    private int timeout = 60000;
    private long leasePeriod = 5000L;
    private boolean leaseManagement = false;
    private Map clientLeases = new ConcurrentHashMap();
    protected Map handlers = new HashMap();
    protected volatile ServerInvocationHandler singleHandler;
    protected volatile CallbackContainer singleCallbackContainer;
    protected Map callbackHandlers = new HashMap();
    protected Map clientCallbackListener = new HashMap();
    protected boolean started = false;
    protected ConnectionNotifier connectionNotifier = new ConnectionNotifier();
    protected ServerSocketFactory serverSocketFactory = null;
    protected boolean registerCallbackListeners = true;
    protected boolean useClientConnectionIdentity;

    public ServerInvoker(InvokerLocator locator) {
        super(locator);
        Map params = locator.getParameters();
        if (this.configuration != null && params != null) {
            this.configuration.putAll(locator.getParameters());
        }
    }

    public ServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    public void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public ConnectionNotifier getConnectionNotifier() {
        return this.connectionNotifier;
    }

    public boolean isLeaseActivated() {
        return this.leaseManagement;
    }

    public void addConnectionListener(ConnectionListener listener) {
        if (listener != null) {
            this.connectionNotifier.addListener(listener);
            if (this.leasePeriod > 0L) {
                this.leaseManagement = true;
            }
        } else {
            throw new IllegalArgumentException("Can not add null ConnectionListener.");
        }
    }

    public void setConnectionListener(Object listener) {
        if (listener == null) {
            log.error((Object)"ConnectionListener is null");
            return;
        }
        if (listener instanceof ConnectionListener) {
            this.addConnectionListener((ConnectionListener)listener);
            return;
        }
        if (!(listener instanceof String)) {
            log.error((Object)"Object supplied as ConnectionListener is neither String nor ConnectionListener");
            return;
        }
        ConnectionListener connectionListener = null;
        try {
            MBeanServer server = this.getMBeanServer();
            ObjectName objName = new ObjectName((String)listener);
            Class c = ConnectionListener.class;
            Object o = MBeanServerInvocationHandler.newProxyInstance(server, objName, c, false);
            connectionListener = (ConnectionListener)o;
        }
        catch (MalformedObjectNameException e) {
            log.debug((Object)"Object supplied as ConnectionListener is not an object name.");
        }
        if (connectionListener == null) {
            try {
                Class listenerClass = ClassLoaderUtility.loadClass((String)listener, ServerInvoker.class);
                connectionListener = (ConnectionListener)listenerClass.newInstance();
            }
            catch (Exception e) {
                log.error((Object)("Unable to instantiate " + listener + ": " + e.getMessage()));
                return;
            }
        }
        if (connectionListener == null) {
            log.error((Object)("Unable to create ConnectionListener from " + listener));
            return;
        }
        this.addConnectionListener(connectionListener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        if (this.connectionNotifier != null) {
            this.connectionNotifier.removeListener(listener);
            if (this.connectionNotifier.size() == 0) {
                this.leaseManagement = false;
                Set clientKeys = this.clientLeases.keySet();
                Iterator itr = clientKeys.iterator();
                while (itr.hasNext()) {
                    String sessionId = (String)itr.next();
                    Lease clientLease = (Lease)this.clientLeases.get(sessionId);
                    clientLease.terminateLease(sessionId);
                }
                this.clientLeases.clear();
            }
        }
    }

    public void setLeasePeriod(long leasePeriodValue) {
        this.leasePeriod = leasePeriodValue;
        if (this.leasePeriod <= 0L) {
            this.leaseManagement = false;
        } else if (this.connectionNotifier != null && this.connectionNotifier.size() > 0) {
            this.leaseManagement = true;
        }
    }

    public Lease getLease(String sessionId) {
        return (Lease)this.clientLeases.get(sessionId);
    }

    public long getLeasePeriod() {
        return this.leasePeriod;
    }

    public String getClientConnectAddress() {
        return this.clientConnectAddress;
    }

    public int getClientConnectPort() {
        return this.clientConnectPort;
    }

    public void setClientConnectPort(int clientConnectPort) {
        this.clientConnectPort = clientConnectPort;
    }

    public void setClientConnectAddress(String clientConnectAddress) {
        this.clientConnectAddress = clientConnectAddress;
    }

    public String getServerBindAddress() {
        return this.serverBindAddress;
    }

    public int getServerBindPort() {
        return this.serverBindPort;
    }

    public List getConnectHomes() {
        return new ArrayList(this.connectHomes);
    }

    public void setConnectHomes(List connectHomes) {
        this.connectHomes = new ArrayList(connectHomes);
    }

    public List getHomes() {
        return new ArrayList(this.homes);
    }

    public void setHomes(List homes) {
        this.homes = new ArrayList(homes);
    }

    public void setMaxNumberOfOnewayThreads(int numOfThreads) {
        this.maxNumberThreads = numOfThreads;
    }

    public int getMaxNumberOfOnewayThreads() {
        return this.maxNumberThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool getOnewayThreadPool() {
        Object object = this.onewayThreadPoolLock;
        synchronized (object) {
            if (this.onewayThreadPool == null) {
                if (this.onewayThreadPoolClass == null || this.onewayThreadPoolClass.length() == 0) {
                    BasicThreadPool pool = new BasicThreadPool("JBossRemoting Server Oneway");
                    pool.setMaximumPoolSize(this.maxNumberThreads);
                    if (this.maxOnewayThreadPoolQueueSize > 0) {
                        pool.setMaximumQueueSize(this.maxOnewayThreadPoolQueueSize);
                    }
                    pool.setBlockingMode(BlockingMode.RUN);
                    this.onewayThreadPool = pool;
                    log.debug((Object)(this + " created new thread pool"));
                } else {
                    boolean isObjName = false;
                    try {
                        ObjectName objName = new ObjectName(this.onewayThreadPoolClass);
                        this.onewayThreadPool = this.createThreadPoolProxy(objName);
                        isObjName = true;
                    }
                    catch (MalformedObjectNameException e) {
                        log.debug((Object)"Thread pool class supplied is not an object name.");
                    }
                    if (!isObjName) {
                        try {
                            this.onewayThreadPool = (ThreadPool)Class.forName(this.onewayThreadPoolClass, false, this.getClassLoader()).newInstance();
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error loading instance of ThreadPool based on class name " + this.onewayThreadPoolClass);
                        }
                    }
                }
            } else {
                log.trace((Object)"reusing oneway thread pool");
            }
            return this.onewayThreadPool;
        }
    }

    public void setOnewayThreadPool(ThreadPool pool) {
        this.onewayThreadPool = pool;
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public void setMBeanServer(MBeanServer server) {
        this.mbeanServer = server;
    }

    public boolean isRegisterCallbackListeners() {
        return this.registerCallbackListeners;
    }

    public void setRegisterCallbackListeners(boolean registerCallbackListeners) {
        this.registerCallbackListeners = registerCallbackListeners;
    }

    public synchronized boolean hasInvocationHandler(String subsystem) {
        return this.handlers.containsKey(subsystem);
    }

    public synchronized String[] getSupportedSubsystems() {
        String[] subsystems = new String[this.handlers.size()];
        return this.handlers.keySet().toArray(subsystems);
    }

    public synchronized ServerInvocationHandler[] getInvocationHandlers() {
        ServerInvocationHandler[] ih = new ServerInvocationHandler[this.handlers.size()];
        return this.handlers.values().toArray(ih);
    }

    public synchronized ServerInvocationHandler addInvocationHandler(String subsystem, ServerInvocationHandler handler) {
        handler.setInvoker(this);
        ServerInvocationHandler oldHandler = this.handlers.put(subsystem.toUpperCase(), handler);
        log.debug((Object)(this + " added " + handler + " for subsystem '" + subsystem + "'" + (oldHandler == null ? "" : ", replacing old handler " + oldHandler)));
        this.singleHandler = this.handlers.size() == 1 ? handler : null;
        return oldHandler;
    }

    public synchronized ServerInvocationHandler removeInvocationHandler(String subsystem) {
        ServerInvocationHandler handler = (ServerInvocationHandler)this.handlers.remove(subsystem.toUpperCase());
        log.debug((Object)(this + (handler == null ? " tried to remove handler for " + subsystem + " but no handler found" : " removed handler " + handler + " for subsystem '" + subsystem + "'")));
        this.singleHandler = this.handlers.size() == 1 ? (ServerInvocationHandler)this.handlers.values().iterator().next() : null;
        return handler;
    }

    public synchronized ServerInvocationHandler getInvocationHandler(String subsystem) {
        return (ServerInvocationHandler)this.handlers.get(subsystem.toUpperCase());
    }

    protected boolean isUseClientConnectionIdentity() {
        return this.useClientConnectionIdentity;
    }

    protected void setUseClientConnectionIdentity(boolean useClientConnectionIdentity) {
        this.useClientConnectionIdentity = useClientConnectionIdentity;
    }

    public Object invoke(Object invoke) throws IOException {
        InvocationRequest request = null;
        InvocationResponse response = null;
        if (trace) {
            log.trace((Object)("server received invocation " + invoke));
        }
        if (invoke != null && invoke instanceof InvocationRequest) {
            request = (InvocationRequest)invoke;
            try {
                Object result = this.invoke(request);
                response = new InvocationResponse(request.getSessionId(), result, false, request.getReturnPayload());
            }
            catch (Throwable throwable) {
                response = new InvocationResponse(request.getSessionId(), throwable, true, request.getReturnPayload());
            }
        } else {
            log.error((Object)("server invoker received " + invoke + " as invocation. " + "Must not be null and must be of type InvocationRequest."));
            Exception e = new Exception("Error processing invocation request on " + this.getLocator() + ". Either invocation was null or of wrong type.");
            response = new InvocationResponse(request.getSessionId(), e, true, request.getReturnPayload());
        }
        return response;
    }

    public Object invoke(InvocationRequest invocation) throws Throwable {
        if (this.isStarted()) {
            Object param = invocation.getParameter();
            Object result = null;
            if (trace) {
                log.trace((Object)(this + " received " + param));
            }
            if (ECHO.equals(param)) {
                return ECHO;
            }
            if (param instanceof String) {
                if ("$PING$".equals(param)) {
                    String invokerSessionId;
                    Map metadata = invocation.getRequestPayload();
                    if (metadata != null && (invokerSessionId = (String)metadata.get(INVOKER_SESSION_ID)) != null) {
                        boolean response = this.checkForClientLease(invokerSessionId);
                        if (trace) {
                            log.trace((Object)(this + " responding " + response + " to $PING$ for invoker sessionId " + invokerSessionId));
                        }
                        return new Boolean(response);
                    }
                    if (this.leaseManagement) {
                        this.updateClientLease(invocation);
                    }
                    HashMap<String, Long> responseMap = new HashMap<String, Long>();
                    responseMap.put(CLIENT_LEASE_PERIOD, new Long(this.leasePeriod));
                    InvocationResponse ir = new InvocationResponse(invocation.getSessionId(), new Boolean(this.leaseManagement), false, responseMap);
                    if (trace) {
                        log.trace((Object)(this + " returning " + ir));
                    }
                    return ir;
                }
                if ("$GET_CLIENT_LOCAL_ADDRESS$".equals(param)) {
                    InetAddress address = null;
                    if (invocation.getRequestPayload() != null) {
                        address = (InetAddress)invocation.getRequestPayload().get("clientAddress");
                    }
                    return address;
                }
                if ("$DISCONNECT$".equals(param)) {
                    if (this.leaseManagement) {
                        this.terminateLease(invocation);
                    }
                    if (trace) {
                        log.trace((Object)(this + " returning null"));
                    }
                    return null;
                }
            }
            if (param instanceof OnewayInvocation) {
                this.handleOnewayInvocation((OnewayInvocation)param, invocation);
                return null;
            }
            String subsystem = invocation.getSubsystem();
            String clientId = invocation.getSessionId();
            ServerInvocationHandler handler = this.findInvocationHandler(subsystem);
            if (param instanceof InternalInvocation) {
                result = this.handleInternalInvocation((InternalInvocation)param, invocation, handler);
            } else {
                if (trace) {
                    log.trace((Object)(this + " dispatching " + invocation + " from client " + clientId + " to subsystem '" + subsystem + "'"));
                }
                if (handler == null) {
                    throw new InvalidConfigurationException("Can not handle invocation request for subsystem '" + subsystem + "' because " + "there are no matching ServerInvocationHandlers registered. Please add via " + "xml configuration or via the Connector's addInvocationHandler() method.");
                }
                result = handler.invoke(invocation);
            }
            if (trace) {
                log.trace((Object)(this + " successfully dispatched invocation, returning " + result + " from subsystem '" + subsystem + "' to client " + clientId));
            }
            return result;
        }
        log.warn((Object)(this + " can not process invocation requests since is not in started state!"));
        throw new InvalidStateException("Can not process invocation request since is not in started state.");
    }

    public String getDataType() {
        if (this.dataType == null) {
            this.dataType = this.getDataType(this.getLocator());
            if (this.dataType == null) {
                this.dataType = this.getDefaultDataType();
            }
        }
        return this.dataType;
    }

    public void create() {
        if (!this.created) {
            try {
                this.setup();
            }
            catch (Exception e) {
                throw new RuntimeException("Error setting up server invoker " + this, e);
            }
            this.created = true;
        }
    }

    public void start() throws IOException {
        this.started = true;
        log.debug((Object)(this + " started for locator " + this.getLocator()));
    }

    public boolean isStarted() {
        return this.started;
    }

    public void stop() {
        this.started = false;
        Iterator i = this.callbackHandlers.values().iterator();
        while (i.hasNext()) {
            ServerInvokerCallbackHandler callbackHandler = (ServerInvokerCallbackHandler)i.next();
            callbackHandler.destroy();
        }
        log.debug((Object)(this + " stopped"));
    }

    public void destroy() {
        if (this.classbyteloader != null) {
            this.classbyteloader.destroy();
        }
    }

    public void setConfiguration(Map configuration) {
        this.configuration = configuration;
    }

    public Map getConfiguration() {
        return this.configuration;
    }

    public void removeCallbackListener(String subsystem, InvokerCallbackHandler callbackHandler) {
        ServerInvocationHandler handler = null;
        if (subsystem != null) {
            handler = (ServerInvocationHandler)this.handlers.get(subsystem.toUpperCase());
        } else if (!this.handlers.isEmpty()) {
            handler = (ServerInvocationHandler)this.handlers.values().iterator().next();
        }
        handler.removeListener(callbackHandler);
    }

    public String getMBeanObjectName() {
        InvokerLocator locator = this.getLocator();
        StringBuffer buffer = new StringBuffer("jboss.remoting:service=invoker,transport=" + locator.getProtocol());
        String host = locator.getHost();
        boolean isIPv6 = host.indexOf("[") >= 0 | host.indexOf(":") >= 0;
        buffer.append(",host=");
        if (isIPv6) {
            buffer.append("\"");
        }
        buffer.append(locator.getHost());
        if (isIPv6) {
            buffer.append("\"");
        }
        buffer.append(",port=").append(locator.getPort());
        Map param = locator.getParameters();
        if (param != null) {
            Iterator itr = param.keySet().iterator();
            while (itr.hasNext()) {
                buffer.append(",");
                String key = (String)itr.next();
                String value = (String)param.get(key);
                buffer.append(key);
                buffer.append("=");
                buffer.append(value);
            }
        }
        return buffer.toString();
    }

    protected abstract String getDefaultDataType();

    protected void setup() throws Exception {
        String registerCallbackListenersString;
        String connectionListener;
        String useClientConnectionIdentityString;
        String clientLeasePeriod;
        String param;
        Map config = this.getConfiguration();
        PortUtil.updateRange(config);
        this.setupHomes(config);
        String maxNumOfThreads = (String)config.get(MAX_NUM_ONEWAY_THREADS_KEY);
        if (maxNumOfThreads != null && maxNumOfThreads.length() > 0) {
            try {
                this.maxNumberThreads = Integer.parseInt(maxNumOfThreads);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Can not convert max number of threads value (" + maxNumOfThreads + ") into a number."));
            }
        }
        if ((param = (String)this.configuration.get(MAX_ONEWAY_THREAD_POOL_QUEUE_SIZE)) != null && param.length() > 0) {
            try {
                this.maxOnewayThreadPoolQueueSize = Integer.parseInt(param);
            }
            catch (NumberFormatException e) {
                log.error((Object)("maxOnewayThreadPoolQueueSize parameter has invalid format: " + param));
            }
        }
        this.onewayThreadPoolClass = (String)config.get(ONEWAY_THREAD_POOL_CLASS_KEY);
        String timeoutPeriod = (String)config.get(TIMEOUT);
        if (timeoutPeriod != null && timeoutPeriod.length() > 0) {
            try {
                this.timeout = Integer.parseInt(timeoutPeriod);
            }
            catch (NumberFormatException e) {
                throw new InvalidConfigurationException("Can not set timeout because can not convert give value (" + timeoutPeriod + ") to a number.");
            }
        }
        if ((clientLeasePeriod = (String)config.get(CLIENT_LEASE_PERIOD)) != null) {
            try {
                long leasePeriodValue = Long.parseLong(clientLeasePeriod);
                this.setLeasePeriod(leasePeriodValue);
            }
            catch (NumberFormatException e) {
                throw new InvalidConfigurationException("Can not set client lease period because can not convert given value (" + clientLeasePeriod + ") to a number.");
            }
        }
        if ((useClientConnectionIdentityString = (String)config.get("useClientConnectionIdentity")) != null) {
            this.useClientConnectionIdentity = Boolean.valueOf(useClientConnectionIdentityString);
        }
        if ((connectionListener = (String)config.get(CONNECTION_LISTENER)) != null) {
            this.setConnectionListener(connectionListener);
        }
        if ((registerCallbackListenersString = (String)config.get(REGISTER_CALLBACK_LISTENER)) != null) {
            this.registerCallbackListeners = Boolean.valueOf(registerCallbackListenersString);
        }
        this.createServerSocketFactory();
        InvokerLocator originalLocator = this.locator;
        this.locator = InvokerLocator.validateLocator(this.locator);
        InvokerRegistry.updateServerInvokerLocator(originalLocator, this.locator);
    }

    /*
     * Unable to fully structure code
     */
    protected void setupHomes(Map config) throws Exception {
        if (this.locator.isMultihome()) {
            this.connectHomes = this.locator.getConnectHomeList();
            o = config.get("connecthomes");
            if (o != null) {
                if (o instanceof Collection) {
                    this.connectHomes.addAll((Collection)o);
                } else if (o instanceof String) {
                    this.connectHomes.addAll(this.createHomeCollection((String)o));
                } else {
                    ServerInvoker.log.warn((Object)(this + ": " + "connecthomes" + " must be a collection or String: " + o));
                }
            }
            this.homes = this.locator.getHomeList();
            o = config.get("homes");
            if (o != null) {
                if (o instanceof Collection) {
                    this.homes.addAll((Collection)o);
                } else if (o instanceof String) {
                    this.homes.addAll(this.createHomeCollection((String)o));
                } else {
                    ServerInvoker.log.warn((Object)(this + ": " + "homes" + " must be a collection or String: " + o));
                }
            }
            if (!this.homes.isEmpty() && this.connectHomes.isEmpty()) {
                this.connectHomes.addAll(this.homes);
            }
            this.assignPorts();
            return;
        }
        locatorhost = this.locator.getHost();
        addr = null;
        addr = locatorhost != null ? ServerInvoker.getAddressByName(locatorhost) : ServerInvoker.getLocalHost();
        port = this.locator.getPort();
        if (port <= 0) {
            port = this.assignPort();
        }
        this.serverBindAddress = (String)config.get("serverBindAddress");
        this.clientConnectAddress = (String)config.get("clientConnectAddress");
        if (this.serverBindAddress == null) {
            this.serverBindAddress = this.clientConnectAddress != null ? ServerInvoker.getLocalHost().getHostAddress() : addr.getHostAddress();
        }
        serverBindPortString = (String)config.get("serverBindPort");
        clientConnectPortString = (String)config.get("clientConnectPort");
        if (clientConnectPortString != null) {
            try {
                this.clientConnectPort = Integer.parseInt(clientConnectPortString);
            }
            catch (NumberFormatException e) {
                throw new InvalidConfigurationException("Can not set client bind port because can not convert given value (" + clientConnectPortString + ") to a number.");
            }
        }
        if (serverBindPortString != null) {
            try {
                this.serverBindPort = Integer.parseInt(serverBindPortString);
                if (this.serverBindPort > 0) ** GOTO lbl58
                this.serverBindPort = this.assignPort();
            }
            catch (NumberFormatException e) {
                throw new InvalidConfigurationException("Can not set server bind port because can not convert given value (" + serverBindPortString + ") to a number.");
            }
        } else {
            this.serverBindPort = this.clientConnectPort > 0 ? PortUtil.findFreePort(this.locator.getHost()) : port;
        }
lbl58:
        // 3 sources

        h = new Home(this.serverBindAddress, this.serverBindPort);
        this.homes.add(h);
        this.connectHomes.add(h);
    }

    protected Collection createHomeCollection(String s) {
        ArrayList<Home> homes = new ArrayList<Home>();
        StringTokenizer st = new StringTokenizer(s, "!");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int p = token.indexOf(58);
            String host = null;
            String portString = null;
            if (p < 0) {
                host = token;
                portString = "-1";
            } else {
                host = token.substring(0, p);
                portString = token.substring(p + 1);
            }
            int port = -1;
            try {
                port = Integer.parseInt(portString);
            }
            catch (Exception e) {
                log.warn((Object)("invalid port value in Home: " + token + ", using -1"));
            }
            Home home = new Home(host, port);
            homes.add(home);
        }
        return homes;
    }

    protected int assignPort() throws IOException {
        int port = PortUtil.findFreePort(this.locator.getHost());
        InvokerLocator newLocator = new InvokerLocator(this.locator.getProtocol(), this.locator.getHost(), port, this.locator.getPath(), this.locator.getParameters());
        InvokerRegistry.updateServerInvokerLocator(this.locator, newLocator);
        this.locator = newLocator;
        return port;
    }

    protected void assignPorts() throws IOException {
        Home home;
        int i;
        boolean changed = false;
        List list = this.homes;
        for (i = 0; i < list.size(); ++i) {
            home = (Home)list.get(i);
            if (home.port >= 0) continue;
            changed = true;
            try {
                home.port = PortUtil.findFreePort(home.host);
                continue;
            }
            catch (Exception e) {
                if (!trace) continue;
                log.trace((Object)(this + " unable to find free port for: " + home.host));
            }
        }
        if (changed) {
            this.locator.setHomeList(this.homes);
        }
        if (this.connectHomes.size() == this.homes.size()) {
            changed = false;
            for (i = 0; i < this.homes.size(); ++i) {
                home = (Home)this.connectHomes.get(i);
                if (home.port >= 0) continue;
                changed = true;
                home.port = ((Home)this.homes.get((int)i)).port;
            }
            if (changed) {
                this.locator.setConnectHomeList(this.connectHomes);
            }
        }
    }

    protected ServerSocketFactory createServerSocketFactory() throws IOException {
        if (this.serverSocketFactory == null) {
            String serverSocketFactoryString;
            Object obj = this.configuration.get("customServerSocketFactory");
            if (obj != null) {
                if (obj instanceof ServerSocketFactory) {
                    this.serverSocketFactory = (ServerSocketFactory)obj;
                } else {
                    throw new RuntimeException("Can not set custom server socket factory (" + obj + ") as is not of type javax.net.SocketFactory");
                }
            }
            if (this.serverSocketFactory == null && (serverSocketFactoryString = (String)this.configuration.get(SERVER_SOCKET_FACTORY)) != null && serverSocketFactoryString.length() > 0) {
                try {
                    if (serverSocketFactoryString != null) {
                        MBeanServer server = this.getMBeanServer();
                        ObjectName serverSocketFactoryObjName = new ObjectName(serverSocketFactoryString);
                        if (server != null) {
                            try {
                                ServerSocketFactoryMBean serverSocketFactoryMBean = (ServerSocketFactoryMBean)MBeanServerInvocationHandler.newProxyInstance(server, serverSocketFactoryObjName, ServerSocketFactoryMBean.class, false);
                                this.serverSocketFactory = new ServerSocketFactoryWrapper(serverSocketFactoryMBean);
                            }
                            catch (Exception e) {
                                log.debug((Object)("Error creating mbean proxy for server socket factory for object name " + serverSocketFactoryObjName + ". " + "Will try by class name."));
                            }
                        } else {
                            log.debug((Object)"The 'serverSocketFactory' attribute was set with a value, but the MBeanServer reference is null.");
                        }
                    }
                }
                catch (MalformedObjectNameException e) {
                    log.debug((Object)("Attibute value (" + serverSocketFactoryString + ") passed is not a " + "valid ObjectName. Can not look up if is a mbean service. Will try by classname."));
                }
                catch (NullPointerException e) {
                    log.debug((Object)"Could not set up the server socket factory as a mbean service due to null pointer exception.");
                }
                if (this.serverSocketFactory == null) {
                    try {
                        Class cl = ClassLoaderUtility.loadClass(serverSocketFactoryString, this.getClass());
                        Constructor serverSocketConstructor = null;
                        serverSocketConstructor = cl.getConstructor(new Class[0]);
                        this.serverSocketFactory = (ServerSocketFactory)serverSocketConstructor.newInstance(new Object[0]);
                        log.trace((Object)("ServerSocketFactory (" + serverSocketFactoryString + ") loaded"));
                    }
                    catch (Exception e) {
                        log.debug((Object)("Could not create server socket factory by classname (" + serverSocketFactoryString + ").  Error message: " + e.getMessage()));
                    }
                }
            }
        }
        if (this.serverSocketFactory == null && ServerInvoker.needsCustomSSLConfiguration(this.configuration)) {
            try {
                SSLSocketBuilder socketBuilder = new SSLSocketBuilder(this.configuration);
                socketBuilder.setUseSSLServerSocketFactory(false);
                this.serverSocketFactory = socketBuilder.createSSLServerSocketFactory();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create customized SSL socket factory", e);
            }
        }
        if (this.serverSocketFactory == null) {
            log.debug((Object)(this + " did not find server socket factory configuration as mbean service " + "or classname. Creating default server socket factory."));
            this.serverSocketFactory = this.getDefaultServerSocketFactory();
        }
        log.debug((Object)(this + " created server socket factory " + this.serverSocketFactory));
        this.serverSocketFactory = this.wrapServerSocketFactory(this.serverSocketFactory, this.configuration);
        return this.serverSocketFactory;
    }

    protected boolean justNeedsSSLClientMode(Map configuration) {
        if (configuration.size() == 1 && configuration.containsKey("org.jboss.remoting.serversocket.useClientMode")) {
            String useClientModeString = (String)configuration.get("org.jboss.remoting.serversocket.useClientMode");
            return Boolean.valueOf(useClientModeString);
        }
        if (configuration.size() == 1 && configuration.containsKey("org.jboss.remoting.socket.useClientMode")) {
            String useClientModeString = (String)configuration.get("org.jboss.remoting.socket.useClientMode");
            return Boolean.valueOf(useClientModeString);
        }
        if (configuration.size() == 2 && configuration.containsKey("org.jboss.remoting.serversocket.useClientMode") && configuration.containsKey("org.jboss.remoting.socket.useClientMode")) {
            String useClientModeString = (String)configuration.get("org.jboss.remoting.serversocket.useClientMode");
            return Boolean.valueOf(useClientModeString);
        }
        return false;
    }

    protected ServerSocketFactory getDefaultServerSocketFactory() throws IOException {
        return ServerSocketFactory.getDefault();
    }

    protected ServerSocketFactory wrapServerSocketFactory(ServerSocketFactory ssf, Map config) {
        if (config == null) {
            return ssf;
        }
        Object o = config.get("socketCreationServerListener");
        if (o == null) {
            return ssf;
        }
        if (o instanceof SocketCreationListener) {
            return new CreationListenerServerSocketFactory(ssf, (SocketCreationListener)o);
        }
        if (o instanceof String) {
            try {
                Class c = ClassLoaderUtility.loadClass((String)o, ServerInvoker.class);
                SocketCreationListener listener = (SocketCreationListener)c.newInstance();
                return new CreationListenerServerSocketFactory(ssf, listener);
            }
            catch (Exception e) {
                log.warn((Object)("unable to instantiate class: " + o), (Throwable)e);
                return ssf;
            }
        }
        log.warn((Object)("unrecognized type for socket creation server listener: " + o));
        return ssf;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object handleInternalInvocation(InternalInvocation param, InvocationRequest invocation, ServerInvocationHandler handler) throws Throwable {
        List result = null;
        String methodName = param.getMethodName();
        if (trace) {
            log.trace((Object)("handling InternalInvocation where method name = " + methodName));
        }
        if ("handleCallback".equals(methodName)) {
            String sessionId = ServerInvokerCallbackHandler.getId(invocation);
            if (trace) {
                log.trace((Object)("ServerInvoker (" + this + ") is being asked to deliver callback on client callback handler with session id of " + sessionId + "."));
            }
            CallbackContainer callbackContainer = null;
            callbackContainer = this.singleCallbackContainer != null ? this.singleCallbackContainer : (CallbackContainer)this.clientCallbackListener.get(sessionId);
            if (callbackContainer != null && callbackContainer.getCallbackHandler() != null) {
                Object[] params = param.getParameters();
                Callback callbackRequest = (Callback)params[0];
                Object obj = callbackContainer.getCallbackHandleObject();
                if (obj != null) {
                    HashMap<String, Object> callbackHandleObject = callbackRequest.getReturnPayload();
                    if (callbackHandleObject == null) {
                        callbackHandleObject = new HashMap<String, Object>();
                    }
                    callbackHandleObject.put("callback_handle_object", obj);
                    callbackRequest.setReturnPayload(callbackHandleObject);
                }
                InvokerCallbackHandler callbackHandler = callbackContainer.getCallbackHandler();
                callbackHandler.handleCallback(callbackRequest);
                return result;
            }
            log.error((Object)("Could not find callback handler to call upon for handleCallback where session id equals " + sessionId));
            return result;
        }
        if ("addListener".equals(methodName)) {
            if (handler == null) {
                throw new InvalidConfigurationException("Can not accept a callback listener since there are no ServerInvocationHandlers registered. Please add via xml configuration or via the Connector's addInvocationHandler() method.");
            }
            ServerInvokerCallbackHandler callbackHandler = this.getCallbackHandler(invocation);
            if (this.registerCallbackListeners) {
                this.connectionNotifier.addListenerFirst(callbackHandler);
                if (this.leasePeriod > 0L) {
                    this.leaseManagement = true;
                }
            }
            handler.addListener(callbackHandler);
            return result;
        }
        if ("removeListener".equals(methodName)) {
            ServerInvokerCallbackHandler callbackHandler = this.removeCallbackHandler(invocation);
            if (callbackHandler == null) {
                String sessionId = ServerInvokerCallbackHandler.getId(invocation);
                throw new RuntimeException("Can not remove callback listener from target server with id of " + sessionId + " as it does not exist as a registered callback listener.");
            }
            if (this.registerCallbackListeners) {
                this.removeConnectionListener(callbackHandler);
            }
            callbackHandler.destroy();
            if (handler == null) {
                throw new InvalidConfigurationException("Can not remove a callback listener since there are no ServerInvocationHandlers registered.  Please add via xml configuration or via the Connector's addInvocationHandler() method.");
            }
            handler.removeListener(callbackHandler);
            if (!trace) return result;
            log.trace((Object)("ServerInvoker (" + this + ") removing server callback handler " + callbackHandler + "."));
            return result;
        }
        if ("getCallbacks".equals(methodName)) {
            ServerInvokerCallbackHandler callbackHandler = this.getCallbackHandler(invocation);
            if (!trace) return callbackHandler.getCallbacks(invocation.getRequestPayload());
            log.trace((Object)("ServerInvoker (" + this + ") getting callbacks for callback handler " + callbackHandler + "."));
            return callbackHandler.getCallbacks(invocation.getRequestPayload());
        }
        if ("acknowledgeCallback".equals(methodName)) {
            ServerInvokerCallbackHandler callbackHandler = this.getCallbackHandler(invocation);
            if (trace) {
                log.trace((Object)("ServerInvoker (" + this + ") acknowledge callback on callback handler " + callbackHandler + "."));
            }
            callbackHandler.acknowledgeCallbacks(param);
            return result;
        }
        if ("addClientListener".equals(methodName)) {
            String sessionId = ServerInvokerCallbackHandler.getId(invocation);
            Object[] params = param.getParameters();
            if (params == null || params.length < 0 || params.length > 3) {
                log.debug((Object)("Received addClientListener InternalInvocation, but getParameters() returned: " + params));
                throw new RuntimeException("InvokerCallbackHandler and callback handle object (optional) must be supplied as the only parameter objects within the InternalInvocation when calling addClientListener.");
            }
            InvokerCallbackHandler callbackHandler = (InvokerCallbackHandler)params[0];
            Object callbackHandleObject = params[1];
            CallbackContainer callbackContainer = new CallbackContainer(callbackHandler, callbackHandleObject);
            this.clientCallbackListener.put(sessionId, callbackContainer);
            this.singleCallbackContainer = this.clientCallbackListener.size() == 1 ? callbackContainer : null;
            log.debug((Object)("ServerInvoker (" + this + ") added client callback handler " + callbackHandler + " with session id of " + sessionId + " and callback handle object of " + callbackHandleObject + "."));
            return result;
        }
        if ("removeClientListener".equals(methodName)) {
            String sessionId = ServerInvokerCallbackHandler.getId(invocation);
            log.debug((Object)("ServerInvoker (" + this + ") removing client callback handler with session " + "id of " + sessionId + "."));
            Object cbo = this.clientCallbackListener.remove(sessionId);
            if (cbo == null) {
                throw new RuntimeException("Can not remove callback listener from callback server with id of " + sessionId + " as it does not exist as a registered callback listener.");
            }
            if (this.clientCallbackListener.size() == 1) {
                this.singleCallbackContainer = (CallbackContainer)this.clientCallbackListener.values().iterator().next();
                return result;
            }
            this.singleCallbackContainer = null;
            return result;
        }
        if ("addStreamCallback".equals(methodName)) {
            StreamHandler streamHandler = this.getStreamHandler(invocation);
            if (handler instanceof StreamInvocationHandler) {
                InternalInvocation inv = (InternalInvocation)invocation.getParameter();
                return ((StreamInvocationHandler)handler).handleStream(streamHandler, (InvocationRequest)inv.getParameters()[1]);
            }
            log.debug((Object)"Client request is an InputStream, but the registered handlers do not implement the StreamInvocationHandler interface, so could not process call.");
            throw new RuntimeException("No handler registered of proper type (StreamInvocationHandler).");
        }
        if (!"echo".equals(methodName)) {
            log.debug((Object)("Error processing InternalInvocation.  Unable to process method " + methodName + ". Please make sure this should be an InternalInvocation."));
            throw new RuntimeException("Error processing InternalInvocation. Unable to process method " + methodName);
        }
        Object response = null;
        Object[] objects = param.getParameters();
        if (objects != null && objects.length > 0) {
            response = objects[0];
        }
        if (!trace) return response;
        log.trace((Object)(this + " echoing " + response));
        return response;
    }

    protected ServerInvocationHandler findInvocationHandler(String subsystem) {
        ServerInvocationHandler handler = null;
        if (this.singleHandler != null) {
            handler = this.singleHandler;
        } else if (subsystem != null) {
            handler = (ServerInvocationHandler)this.handlers.get(subsystem.toUpperCase());
        } else if (!this.handlers.isEmpty()) {
            if (trace) {
                log.trace((Object)(this + " handling invocation with no subsystem explicitely specified, using the default handler"));
            }
            handler = (ServerInvocationHandler)this.handlers.values().iterator().next();
        }
        return handler;
    }

    protected void preProcess(String sessionId, ClassBytes arg, Map payload, InvokerLocator locator) {
    }

    protected void postProcess(String sessionId, Object param, Map payload, InvokerLocator locator) {
    }

    private ThreadPool createThreadPoolProxy(ObjectName objName) {
        MBeanServer server = this.getMBeanServer();
        if (server == null) {
            throw new RuntimeException("Can not register MBean ThreadPool as the ServerInvoker has not been registered with a MBeanServer.");
        }
        ThreadPoolMBean poolMBean = (ThreadPoolMBean)MBeanServerInvocationHandler.newProxyInstance(server, objName, ThreadPoolMBean.class, false);
        ThreadPool pool = poolMBean.getInstance();
        return pool;
    }

    private String getDataType(InvokerLocator locator) {
        Map params;
        String type = null;
        if (locator != null && (params = locator.getParameters()) != null) {
            type = (String)params.get("datatype");
        }
        return type;
    }

    private void terminateLease(InvocationRequest invocation) {
        if (invocation != null) {
            String clientSessionId = invocation.getSessionId();
            Lease clientLease = (Lease)this.clientLeases.get(clientSessionId);
            if (clientLease != null) {
                Object holderObj;
                boolean clientOnlyTerminated = false;
                Map reqMap = invocation.getRequestPayload();
                if (reqMap != null && (holderObj = reqMap.get("ClientHolderKey")) != null && holderObj instanceof ClientHolder) {
                    if (trace) {
                        log.trace((Object)("terminating client lease: " + clientSessionId));
                    }
                    ClientHolder holder = (ClientHolder)holderObj;
                    clientLease.terminateLease(holder.getSessionId());
                    clientOnlyTerminated = true;
                }
                if (!clientOnlyTerminated) {
                    if (trace) {
                        log.trace((Object)("terminating invoker lease: " + clientSessionId));
                    }
                    clientLease.terminateLease(clientSessionId);
                    this.clientLeases.remove(clientSessionId);
                }
            } else {
                Object holderObj;
                String type = "invoker";
                Map reqMap = invocation.getRequestPayload();
                if (reqMap != null && (holderObj = reqMap.get("ClientHolderKey")) != null && holderObj instanceof ClientHolder) {
                    type = "client";
                }
                log.debug((Object)("Asked to terminate " + type + " lease for invoker session id " + clientSessionId + ", but lease for this id could not be found." + "" + "Probably has been removed due to connection failure."));
            }
        }
    }

    private void updateClientLease(InvocationRequest invocation) {
        if (invocation != null) {
            String clientSessionId = invocation.getSessionId();
            if (invocation.getRequestPayload() != null) {
                invocation.getRequestPayload().remove(TIMEOUT);
            }
            if (clientSessionId != null) {
                Lease clientLease;
                if (trace) {
                    log.trace((Object)("Getting lease for invoker session id: " + clientSessionId));
                }
                if ((clientLease = (Lease)this.clientLeases.get(clientSessionId)) == null) {
                    Lease newClientLease = new Lease(clientSessionId, this.leasePeriod, this.locator.getLocatorURI(), invocation.getRequestPayload(), this.connectionNotifier, this.clientLeases);
                    this.clientLeases.put(clientSessionId, newClientLease);
                    newClientLease.startLease();
                    if (trace) {
                        log.trace((Object)("No lease established for invoker session id (" + clientSessionId + "), so starting a new one:" + newClientLease));
                    }
                } else if (this.useClientConnectionIdentity) {
                    String leasePingerId = (String)invocation.getRequestPayload().get("leasePingerId");
                    if (leasePingerId == null || leasePingerId.equals(clientLease.getLeasePingerId())) {
                        if (trace) {
                            log.trace((Object)(clientLease + " matches: leasePingerId: " + leasePingerId));
                        }
                        clientLease.updateLease(this.leasePeriod, invocation.getRequestPayload());
                        if (trace) {
                            log.trace((Object)("Updated lease for invoker session id (" + clientSessionId + ")"));
                        }
                    } else {
                        if (trace) {
                            log.trace((Object)(clientLease + " does not match: leasePingerId: " + leasePingerId));
                        }
                        if (trace) {
                            log.trace((Object)("terminating invoker lease: " + clientLease));
                        }
                        clientLease.terminateLeaseUponFailure(clientSessionId);
                        this.clientLeases.remove(clientSessionId);
                        Lease newClientLease = new Lease(clientSessionId, this.leasePeriod, this.locator.getLocatorURI(), invocation.getRequestPayload(), this.connectionNotifier, this.clientLeases);
                        this.clientLeases.put(clientSessionId, newClientLease);
                        newClientLease.startLease();
                        if (trace) {
                            log.trace((Object)("starting a new lease:" + newClientLease));
                        }
                    }
                } else {
                    clientLease.updateLease(this.leasePeriod, invocation.getRequestPayload());
                    if (trace) {
                        log.trace((Object)("Updated lease for client session id (" + clientSessionId + ")"));
                    }
                }
            }
        }
    }

    private boolean checkForClientLease(String invokerSessionId) {
        if (this.leaseManagement && invokerSessionId != null) {
            Lease clientLease;
            if (trace) {
                log.trace((Object)("Checking lease for invoker session id: " + invokerSessionId));
            }
            if ((clientLease = (Lease)this.clientLeases.get(invokerSessionId)) == null) {
                if (trace) {
                    log.trace((Object)("No lease established for invoker session id (" + invokerSessionId + ")"));
                }
                return false;
            }
            if (trace) {
                log.trace((Object)("Found lease for invoker session id (" + invokerSessionId + ")"));
            }
            return true;
        }
        return false;
    }

    private void handleOnewayInvocation(OnewayInvocation onewayInvocation, InvocationRequest invocation) throws Throwable {
        Object[] objs = onewayInvocation.getParameters();
        Object realParam = objs[0];
        invocation.setParameter(realParam);
        final InvocationRequest newInvocation = invocation;
        ThreadPool executor = this.getOnewayThreadPool();
        Runnable onewayRun = new Runnable(){

            public void run() {
                try {
                    ServerInvoker.this.invoke(newInvocation);
                }
                catch (Throwable e) {
                    log.error((Object)("Error executing server oneway invocation request: " + newInvocation), e);
                }
            }
        };
        if (trace) {
            log.trace((Object)(this + " placing " + invocation + " in onewayThreadPool"));
        }
        executor.run(onewayRun);
    }

    private StreamHandler getStreamHandler(InvocationRequest invocation) throws Exception {
        InternalInvocation inv = (InternalInvocation)invocation.getParameter();
        String locator = (String)inv.getParameters()[0];
        return new StreamHandler(locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerInvokerCallbackHandler getCallbackHandler(InvocationRequest invocation) throws Exception {
        ServerInvokerCallbackHandler callbackHandler = null;
        String id = ServerInvokerCallbackHandler.getId(invocation);
        Map map = this.callbackHandlers;
        synchronized (map) {
            callbackHandler = (ServerInvokerCallbackHandler)this.callbackHandlers.get(id);
            if (callbackHandler == null) {
                callbackHandler = new ServerInvokerCallbackHandler(invocation, this.getLocator(), this);
                this.callbackHandlers.put(id, callbackHandler);
            }
        }
        callbackHandler.connect();
        if (trace) {
            log.trace((Object)("ServerInvoker (" + this + ") adding server callback handler " + callbackHandler + " with id of " + id + "."));
        }
        return callbackHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInvokerCallbackHandler removeCallbackHandler(InvocationRequest invocation) {
        String id = ServerInvokerCallbackHandler.getId(invocation);
        ServerInvokerCallbackHandler callbackHandler = null;
        Map map = this.callbackHandlers;
        synchronized (map) {
            callbackHandler = (ServerInvokerCallbackHandler)this.callbackHandlers.remove(id);
        }
        log.debug((Object)(this + " removed " + callbackHandler));
        return callbackHandler;
    }

    public void shutdownCallbackHandler(ServerInvokerCallbackHandler callbackHandler, InvocationRequest invocation) {
        ServerInvocationHandler handler;
        this.removeCallbackHandler(invocation);
        if (this.registerCallbackListeners) {
            this.removeConnectionListener(callbackHandler);
        }
        if ((handler = this.findInvocationHandler(invocation.getSessionId())) != null) {
            handler.removeListener(callbackHandler);
            if (trace) {
                log.trace((Object)(this + " removing server callback handler " + callbackHandler + "."));
            }
        } else {
            log.debug((Object)(this + " cannot remove " + callbackHandler + ": associated ServerInvocationHandler not longer exists"));
        }
    }

    private static InetAddress getLocalHost() throws UnknownHostException {
        if (SecurityUtility.skipAccessControl()) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (IOException e) {
                return InetAddress.getByName("127.0.0.1");
            }
        }
        try {
            return (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    try {
                        return InetAddress.getLocalHost();
                    }
                    catch (IOException e) {
                        return InetAddress.getByName("127.0.0.1");
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }

    private static InetAddress getAddressByName(final String host) throws UnknownHostException {
        if (SecurityUtility.skipAccessControl()) {
            return InetAddress.getByName(host);
        }
        try {
            return (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return InetAddress.getByName(host);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }

    private class CallbackContainer {
        private InvokerCallbackHandler handler;
        private Object handleObject;

        public CallbackContainer(InvokerCallbackHandler handler, Object handleObject) {
            this.handler = handler;
            this.handleObject = handleObject;
        }

        public InvokerCallbackHandler getCallbackHandler() {
            return this.handler;
        }

        public Object getCallbackHandleObject() {
            return this.handleObject;
        }
    }

    public static class InvalidStateException
    extends Exception {
        public InvalidStateException(String msg) {
            super(msg);
        }
    }
}

