/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.transporter.custom.server;

import java.lang.reflect.Method;
import java.net.InetAddress;
import org.jboss.remoting.samples.detection.jndi.SimpleJNDIServer;
import org.jboss.remoting.util.SecurityUtility;
import org.jnp.server.Main;

public class JNDIServer {
    public static final int JNDI_PORT = 2410;

    public static void main(String[] args) {
        try {
            Object namingBean = null;
            Class<?> namingBeanImplClass = null;
            try {
                namingBeanImplClass = Class.forName("org.jnp.server.NamingBeanImpl");
                namingBean = namingBeanImplClass.newInstance();
                Method startMethod = namingBeanImplClass.getMethod("start", new Class[0]);
                SecurityUtility.setSystemProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                startMethod.invoke(namingBean, new Object[0]);
            }
            catch (Exception e) {
                SimpleJNDIServer.println("Cannot find NamingBeanImpl: must be running jdk 1.4");
            }
            String host = InetAddress.getLocalHost().getHostAddress();
            Main jserver = new Main();
            if (namingBean != null) {
                Class<?> namingBeanClass = Class.forName("org.jnp.server.NamingBean");
                Method setNamingInfoMethod = jserver.getClass().getMethod("setNamingInfo", namingBeanClass);
                setNamingInfoMethod.invoke((Object)jserver, namingBean);
            }
            int port = 2410;
            jserver.setPort(port);
            jserver.setBindAddress(host);
            jserver.setRmiPort(31000);
            jserver.start();
            System.out.println("Started JNDI server on " + host + ":" + port);
            while (true) {
                Thread.sleep(5000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

