/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.stream;

import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import javax.management.MBeanServer;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.stream.StreamCallPayload;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.PortUtil;
import org.jboss.remoting.util.LocalHostUtil;

public class StreamServer {
    private InputStream streamSource = null;
    private String transport = "socket";
    private String host = "localhost";
    private int port = 5405;
    private Connector connector = null;
    private boolean internalConnector = true;
    private static final Logger log = Logger.getLogger((Class)StreamServer.class);
    public static final String STREAM_TRANSPORT_KEY = "remoting.stream.transport";
    public static final String STREAM_HOST_KEY = "remoting.stream.host";
    public static final String STREAM_PORT_KEY = "remoting.stream.port";

    public StreamServer(InputStream stream) throws Exception {
        this.streamSource = stream;
        String locatorURI = this.getLocatorURI();
        this.setupServer(locatorURI);
    }

    public StreamServer(InputStream stream, InvokerLocator locator) throws Exception {
        this.streamSource = stream;
        this.setupServer(locator.getLocatorURI());
    }

    public StreamServer(InputStream stream, Connector connector) throws Exception {
        this.streamSource = stream;
        this.connector = connector;
        if (connector != null) {
            if (!connector.isStarted()) {
                throw new IllegalStateException("Connector (" + connector + ") passed to act as stream server has not been started.");
            }
        } else {
            throw new NullPointerException("Connector passed to act as stream server can not be null.");
        }
        Handler invocationHandler = new Handler(connector);
        connector.addInvocationHandler("stream", invocationHandler);
        this.internalConnector = false;
    }

    private String getLocatorURI() throws IOException {
        this.transport = System.getProperty(STREAM_TRANSPORT_KEY, this.transport);
        try {
            this.host = LocalHostUtil.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            try {
                this.host = LocalHostUtil.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e1) {
                log.error((Object)"Stream server could not determine local host or address.");
            }
        }
        this.host = System.getProperty(STREAM_HOST_KEY, this.host);
        String sPort = System.getProperty(STREAM_PORT_KEY, "" + PortUtil.findFreePort(this.host));
        try {
            this.port = Integer.parseInt(sPort);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Stream server could not convert specified port " + sPort + " to a number."));
        }
        return this.transport + "://" + this.host + ":" + this.port;
    }

    public String getInvokerLocator() throws Exception {
        String locator = null;
        if (this.connector != null) {
            locator = this.connector.getInvokerLocator();
        }
        return locator;
    }

    public void setupServer(String locatorURI) throws Exception {
        InvokerLocator locator = new InvokerLocator(locatorURI);
        this.connector = new Connector();
        this.connector.setInvokerLocator(locator.getLocatorURI());
        this.connector.create();
        Handler invocationHandler = new Handler(this.connector);
        this.connector.addInvocationHandler("stream", invocationHandler);
        this.connector.start();
    }

    public class Handler
    implements ServerInvocationHandler {
        private Connector connector = null;

        public Handler(Connector connector) {
            this.connector = connector;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Object invoke(InvocationRequest invocation) throws Throwable {
            Object obj = invocation.getParameter();
            if (!(obj instanceof StreamCallPayload)) {
                log.error((Object)"Can not process invocation request because is not of type StreamCallPayload.");
                throw new Exception("Invalid payload type.  Must be of type StreamCallPayload.");
            }
            StreamCallPayload payload = (StreamCallPayload)obj;
            String method = payload.getMethod();
            if ("read()".equals(method)) {
                int i = StreamServer.this.streamSource.read();
                return new Integer(i);
            }
            if ("available()".equals(method)) {
                int i = StreamServer.this.streamSource.available();
                return new Integer(i);
            }
            if ("close()".equals(method)) {
                StreamServer.this.streamSource.close();
                if (this.connector == null) return null;
                if (!StreamServer.this.internalConnector) return null;
                this.connector.stop();
                this.connector.destroy();
                return null;
            }
            if ("reset()".equals(method)) {
                StreamServer.this.streamSource.reset();
                return null;
            }
            if ("markSupported()".equals(method)) {
                boolean b = StreamServer.this.streamSource.markSupported();
                return new Boolean(b);
            }
            if ("mark(int readlimit)".equals(method)) {
                Object[] param = payload.getParams();
                Integer intr = (Integer)param[0];
                int readLimit = intr;
                StreamServer.this.streamSource.mark(readLimit);
                return null;
            }
            if ("skip(long n)".equals(method)) {
                Object[] param = payload.getParams();
                Long lg = (Long)param[0];
                long n = lg;
                long ret = StreamServer.this.streamSource.skip(n);
                return new Long(ret);
            }
            if (!"read(byte b[])".equals(method)) throw new Exception("Unsupported method call - " + method);
            Object[] param = payload.getParams();
            byte[] byteParam = (byte[])param[0];
            int i = StreamServer.this.streamSource.read(byteParam);
            StreamCallPayload ret = new StreamCallPayload("read(byte b[])");
            ret.setParams(new Object[]{byteParam, new Integer(i)});
            return ret;
        }

        public void addListener(InvokerCallbackHandler callbackHandler) {
        }

        public void removeListener(InvokerCallbackHandler callbackHandler) {
        }

        public void setMBeanServer(MBeanServer server) {
        }

        public void setInvoker(ServerInvoker invoker) {
        }
    }
}

