/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.List;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.resolver.XBundleRevision;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;

public class OSGiMetaDataProcessor {
    private OSGiMetaDataProcessor() {
    }

    public static OSGiMetaData loadOsgiMetaData(Module module) {
        Version version;
        ModuleIdentifier moduleId = module.getIdentifier();
        String symbolicName = moduleId.getName();
        try {
            version = Version.parseVersion((String)moduleId.getSlot());
        }
        catch (IllegalArgumentException ex) {
            version = Version.emptyVersion;
        }
        final OSGiMetaDataBuilder builder = OSGiMetaDataBuilder.createBuilder((String)symbolicName, (Version)version);
        new ModuleExportPackagesCollector(module){

            @Override
            protected void addPackage(String packageName) {
                builder.addExportPackages(new String[]{packageName});
            }
        }.collectExportPackages();
        return builder.getOSGiMetaData();
    }

    public static OSGiMetaData getOsgiMetaData(XBundleRevision brev) {
        OSGiMetaDataBuilder metaBuilder = OSGiMetaDataBuilder.createBuilder((String)brev.getSymbolicName(), (Version)brev.getVersion());
        List exportedPaths = brev.getCapabilities("osgi.wiring.package");
        for (Capability cap : exportedPaths) {
            metaBuilder.addExportPackages(new String[]{cap.getAttributes().get("osgi.wiring.package").toString()});
        }
        return metaBuilder.getOSGiMetaData();
    }

    public static abstract class ModuleExportPackagesCollector {
        private final Module module;

        public ModuleExportPackagesCollector(Module module) {
            this.module = module;
        }

        public final void collectExportPackages() {
            for (String path : this.module.getExportedPaths()) {
                if (path.length() <= 0) continue;
                String packageName = path.replace('/', '.');
                this.addPackage(packageName);
            }
        }

        protected abstract void addPackage(String var1);
    }
}

