/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.Collections;
import java.util.Map;
import org.jboss.osgi.resolver.ResolverMessages;
import org.jboss.osgi.resolver.XAttributeSupport;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XDirectiveSupport;
import org.jboss.osgi.resolver.XHostCapability;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XProvidedCapability;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceCapability;
import org.jboss.osgi.resolver.spi.AbstractElement;
import org.jboss.osgi.resolver.spi.AbstractResource;
import org.jboss.osgi.resolver.spi.AttributeSupporter;
import org.jboss.osgi.resolver.spi.DirectiveSupporter;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;

public class AbstractCapability
extends AbstractElement
implements XIdentityCapability,
XHostCapability,
XPackageCapability,
XResourceCapability,
XProvidedCapability {
    private final String namespace;
    private final XResource resource;
    private XAttributeSupport attributes;
    private XDirectiveSupport directives;
    private String namespaceValue;
    private String canonicalName;
    private Version version;
    private boolean valid;

    public AbstractCapability(XResource resource, String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        if (resource == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("resource");
        }
        if (namespace == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("namespace");
        }
        if (atts == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("attributes");
        }
        if (dirs == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("directives");
        }
        this.resource = resource;
        this.namespace = namespace;
        this.attributes = new AttributeSupporter(atts);
        this.directives = new DirectiveSupporter(dirs);
    }

    @Override
    public XResource getResource() {
        return this.resource;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.isMutable() ? this.directives.getDirectives() : Collections.unmodifiableMap(this.directives.getDirectives());
    }

    @Override
    public String getDirective(String key) {
        return this.directives.getDirective(key);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.isMutable() ? this.attributes.getAttributes() : Collections.unmodifiableMap(this.attributes.getAttributes());
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.getAttribute(key);
    }

    private boolean isMutable() {
        return this.resource.isMutable();
    }

    @Override
    public void validate() {
        if (!this.valid) {
            if (AbstractResource.identityNamespaces.contains(this.getNamespace())) {
                this.version = AbstractCapability.getVersion(this, "version");
                this.namespaceValue = (String)this.getAttribute(this.getNamespace());
                if (this.namespaceValue == null) {
                    throw ResolverMessages.MESSAGES.illegalStateCannotObtainAttribute(this.getNamespace());
                }
            } else if ("osgi.wiring.bundle".equals(this.getNamespace())) {
                this.version = AbstractCapability.getVersion(this, "bundle-version");
                this.namespaceValue = (String)this.getAttribute(this.getNamespace());
                if (this.namespaceValue == null) {
                    throw ResolverMessages.MESSAGES.illegalStateCannotObtainAttribute(this.getNamespace());
                }
            } else if ("osgi.wiring.host".equals(this.getNamespace())) {
                this.version = AbstractCapability.getVersion(this, "bundle-version");
                this.namespaceValue = (String)this.getAttribute(this.getNamespace());
                if (this.namespaceValue == null) {
                    throw ResolverMessages.MESSAGES.illegalStateCannotObtainAttribute(this.getNamespace());
                }
            } else if ("osgi.wiring.package".equals(this.getNamespace())) {
                this.version = AbstractCapability.getVersion(this, "version");
                this.attributes.getAttributes().put("version", this.version);
                this.namespaceValue = (String)this.getAttribute(this.getNamespace());
                if (this.namespaceValue == null) {
                    throw ResolverMessages.MESSAGES.illegalStateCannotObtainAttribute(this.getNamespace());
                }
            }
            this.canonicalName = this.toString();
            this.valid = true;
        }
    }

    @Override
    public <T extends XCapability> T adapt(Class<T> clazz) {
        AbstractCapability result = null;
        if (XIdentityCapability.class == clazz && AbstractResource.identityNamespaces.contains(this.getNamespace())) {
            result = this;
        } else if (XResourceCapability.class == clazz && "osgi.wiring.bundle".equals(this.getNamespace())) {
            result = this;
        } else if (XHostCapability.class == clazz && "osgi.wiring.host".equals(this.getNamespace())) {
            result = this;
        } else if (XPackageCapability.class == clazz && "osgi.wiring.package".equals(this.getNamespace())) {
            result = this;
        }
        return (T)result;
    }

    @Override
    public String getPackageName() {
        return this.namespaceValue;
    }

    @Override
    public String getName() {
        return this.namespaceValue;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    static Version getVersion(Capability cap, String attname) {
        Object attval = cap.getAttributes().get(attname);
        if (attval != null && !(attval instanceof Version)) {
            attval = new Version(attval.toString());
            cap.getAttributes().put(attname, attval);
        }
        return attval != null ? (Version)attval : Version.emptyVersion;
    }

    @Override
    public String getType() {
        String typeval = (String)this.getAttribute("type");
        return typeval != null ? typeval : "unknown";
    }

    @Override
    public boolean isSingleton() {
        return Boolean.parseBoolean(this.getDirective("singleton"));
    }

    public String toString() {
        String result = this.canonicalName;
        if (result == null) {
            XIdentityCapability icap;
            String type;
            String nsval = null;
            if (AbstractResource.identityNamespaces.contains(this.getNamespace())) {
                type = XIdentityCapability.class.getSimpleName();
            } else if ("osgi.wiring.bundle".equals(this.getNamespace())) {
                type = XResourceCapability.class.getSimpleName();
            } else if ("osgi.wiring.host".equals(this.getNamespace())) {
                type = XHostCapability.class.getSimpleName();
            } else if ("osgi.wiring.package".equals(this.getNamespace())) {
                type = XPackageCapability.class.getSimpleName();
            } else {
                type = XProvidedCapability.class.getSimpleName();
                nsval = this.namespace;
            }
            StringBuffer buffer = new StringBuffer(type + "[");
            boolean addcomma = false;
            if (nsval != null) {
                buffer.append(nsval);
                addcomma = true;
            }
            if (!this.getAttributes().isEmpty()) {
                buffer.append(addcomma ? "," : "");
                buffer.append("atts=" + this.attributes);
                addcomma = true;
            }
            if (!this.getDirectives().isEmpty()) {
                buffer.append(addcomma ? "," : "");
                buffer.append("dirs=" + this.directives);
                addcomma = true;
            }
            if ((icap = this.resource.getIdentityCapability()) != null) {
                buffer.append(addcomma ? "," : "");
                buffer.append("[" + icap.getName() + ":" + icap.getVersion() + "]");
                addcomma = true;
            } else {
                buffer.append(addcomma ? "," : "");
                buffer.append("[anonymous]");
                addcomma = true;
            }
            buffer.append("]");
            result = buffer.toString();
        }
        return result;
    }
}

