/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.Resource;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.metadata.PackageAttribute;
import org.jboss.osgi.metadata.Parameter;
import org.jboss.osgi.metadata.ParameterizedAttribute;
import org.jboss.osgi.resolver.MavenCoordinates;
import org.jboss.osgi.resolver.ResolverMessages;
import org.jboss.osgi.resolver.ResourceBuilderException;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.jboss.osgi.resolver.XResourceBuilderFactory;
import org.jboss.osgi.resolver.spi.AbstractResource;
import org.jboss.osgi.resolver.spi.ResourceValidationException;
import org.osgi.framework.Filter;
import org.osgi.framework.Version;

public class AbstractResourceBuilder<T extends XResource>
implements XResourceBuilder<T> {
    private final XResourceBuilderFactory<T> factory;
    private final T resource;

    public AbstractResourceBuilder(XResourceBuilderFactory<T> factory) {
        if (factory == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("factory");
        }
        this.factory = factory;
        this.resource = factory.createResource();
    }

    @Override
    public XResourceBuilder<T> addAttribute(String key, String value) {
        this.assertResourceCreated();
        this.resource.getAttributes().put(key, value);
        return this;
    }

    @Override
    public XIdentityCapability addIdentityCapability(String symbolicName, Version version) {
        this.assertResourceCreated();
        XIdentityCapability icap = (XIdentityCapability)this.addCapability("osgi.identity", symbolicName);
        icap.getAttributes().put("version", version);
        return icap;
    }

    @Override
    public XIdentityCapability addIdentityCapability(ModuleIdentifier moduleId) {
        Version version;
        this.assertResourceCreated();
        String nsvalue = moduleId.getName();
        try {
            version = Version.parseVersion((String)moduleId.getSlot());
        }
        catch (IllegalArgumentException ex) {
            version = Version.emptyVersion;
        }
        XIdentityCapability icap = (XIdentityCapability)this.addCapability("module.identity", nsvalue);
        icap.getAttributes().put("type", "module");
        icap.getAttributes().put("name", moduleId.getName());
        icap.getAttributes().put("slot", moduleId.getSlot());
        icap.getAttributes().put("version", version);
        return icap;
    }

    @Override
    public XIdentityCapability addIdentityCapability(MavenCoordinates mavenId) {
        Version version;
        this.assertResourceCreated();
        String nsvalue = mavenId.getArtifactId();
        try {
            version = Version.parseVersion((String)mavenId.getVersion());
        }
        catch (IllegalArgumentException ex) {
            version = Version.emptyVersion;
        }
        XIdentityCapability icap = (XIdentityCapability)this.addCapability("maven.identity", nsvalue);
        icap.getAttributes().put("type", mavenId.getType());
        icap.getAttributes().put("groupId", mavenId.getGroupId());
        icap.getAttributes().put("artifactId", mavenId.getArtifactId());
        icap.getAttributes().put("version", version);
        if (mavenId.getClassifier() != null) {
            icap.getAttributes().put("classifier", mavenId.getClassifier());
        }
        return icap;
    }

    @Override
    public XCapability addCapability(String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        XCapability cap = this.factory.createCapability((XResource)this.resource, namespace, this.mutableAttributes(atts), this.mutableDirectives(dirs));
        this.addCapability(cap);
        return cap;
    }

    @Override
    public XCapability addCapability(String namespace, String nsvalue) {
        return this.addCapability(namespace, Collections.singletonMap(namespace, nsvalue), null);
    }

    @Override
    public XRequirement addRequirement(String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        XRequirement req = this.factory.createRequirement((XResource)this.resource, namespace, this.mutableAttributes(atts), this.mutableDirectives(dirs));
        this.addRequirement(req);
        return req;
    }

    @Override
    public XRequirement addRequirement(String namespace, Filter filter) {
        this.assertResourceCreated();
        LinkedHashMap<String, String> dirs = new LinkedHashMap<String, String>();
        if (filter != null) {
            dirs.put("filter", filter.toString());
        }
        return this.addRequirement(namespace, null, dirs);
    }

    @Override
    public XRequirement addRequirement(String namespace, String nsvalue) {
        this.assertResourceCreated();
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (nsvalue != null) {
            atts.put(namespace, nsvalue);
        }
        return this.addRequirement(namespace, atts, null);
    }

    @Override
    public XResourceBuilder<T> loadFrom(OSGiMetaData metadata) throws ResourceBuilderException {
        this.assertResourceCreated();
        try {
            List requiredCapabilities;
            List providedCapabilities;
            XRequirement req;
            List dynamicImports;
            List imports;
            List exports;
            List requiredEnvironments;
            List requireBundles;
            String symbolicName = metadata.getBundleSymbolicName();
            Version bundleVersion = metadata.getBundleVersion();
            ParameterizedAttribute fragmentHost = metadata.getFragmentHost();
            ParameterizedAttribute idparams = metadata.getBundleParameters();
            Map<String, Object> idatts = this.getAttributes(idparams);
            Map<String, String> isdirs = this.getDirectives(idparams);
            if (symbolicName == null) {
                symbolicName = "anonymous-bundle-symbolic-name";
            }
            XIdentityCapability icap = this.addIdentityCapability(symbolicName, bundleVersion);
            String identityType = fragmentHost != null ? "osgi.fragment" : "osgi.bundle";
            icap.getAttributes().put("type", identityType);
            icap.getAttributes().putAll(idatts);
            icap.getDirectives().putAll(isdirs);
            if ("osgi.bundle".equals(identityType)) {
                XCapability cap = this.addCapability("osgi.wiring.bundle", symbolicName);
                cap.getAttributes().put("bundle-version", bundleVersion);
                cap.getAttributes().putAll(idatts);
                cap.getDirectives().putAll(isdirs);
            }
            String fragmentAttachemnt = isdirs.get("fragment-attachment");
            if (fragmentHost == null && !"never".equals(fragmentAttachemnt)) {
                XCapability cap = this.addCapability("osgi.wiring.host", symbolicName);
                cap.getAttributes().put("bundle-version", bundleVersion);
                cap.getAttributes().putAll(idatts);
                cap.getDirectives().putAll(isdirs);
            }
            if (fragmentHost != null) {
                String hostName = fragmentHost.getAttribute();
                XRequirement req2 = this.addRequirement("osgi.wiring.host", hostName);
                req2.getAttributes().putAll(this.getAttributes(fragmentHost));
                req2.getDirectives().putAll(this.getDirectives(fragmentHost));
            }
            if ((requireBundles = metadata.getRequireBundles()) != null && !requireBundles.isEmpty()) {
                for (ParameterizedAttribute attr : requireBundles) {
                    String bundleName = attr.getAttribute();
                    XRequirement req3 = this.addRequirement("osgi.wiring.bundle", bundleName);
                    req3.getAttributes().putAll(this.getAttributes(attr));
                    req3.getDirectives().putAll(this.getDirectives(attr));
                }
            }
            if ((requiredEnvironments = metadata.getRequiredExecutionEnvironment()) != null && !requiredEnvironments.isEmpty()) {
                Filter filter = OSGiMetaDataBuilder.convertExecutionEnvironmentHeader((List)requiredEnvironments);
                this.addRequirement("osgi.ee", filter);
            }
            if ((exports = metadata.getExportPackages()) != null && !exports.isEmpty()) {
                for (PackageAttribute attr : exports) {
                    Object vspec;
                    String packageName = attr.getAttribute();
                    XCapability cap = this.addCapability("osgi.wiring.package", packageName);
                    cap.getAttributes().putAll(this.getAttributes((ParameterizedAttribute)attr));
                    cap.getDirectives().putAll(this.getDirectives((ParameterizedAttribute)attr));
                    Map capatts = cap.getAttributes();
                    if (!capatts.containsKey("bundle-symbolic-name")) {
                        capatts.put("bundle-symbolic-name", symbolicName);
                    }
                    if (!capatts.containsKey("bundle-version")) {
                        capatts.put("bundle-version", bundleVersion);
                    }
                    if (capatts.containsKey("specification-version") || (vspec = capatts.get("version")) == null) continue;
                    try {
                        Version version = Version.parseVersion((String)vspec.toString());
                        capatts.put("specification-version", version);
                    }
                    catch (RuntimeException ex) {}
                }
            }
            if ((imports = metadata.getImportPackages()) != null && !imports.isEmpty()) {
                for (PackageAttribute attr : imports) {
                    String packageName = attr.getAttribute();
                    XRequirement req4 = this.addRequirement("osgi.wiring.package", packageName);
                    req4.getAttributes().putAll(this.getAttributes((ParameterizedAttribute)attr));
                    req4.getDirectives().putAll(this.getDirectives((ParameterizedAttribute)attr));
                }
            }
            if ((dynamicImports = metadata.getDynamicImports()) != null && !dynamicImports.isEmpty()) {
                for (PackageAttribute attr : dynamicImports) {
                    String packageName = attr.getAttribute();
                    LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
                    LinkedHashMap<String, String> dirs = new LinkedHashMap<String, String>();
                    atts.put("osgi.wiring.package", packageName);
                    dirs.put("resolution", "dynamic");
                    req = this.addRequirement("osgi.wiring.package", atts, dirs);
                    req.getAttributes().putAll(this.getAttributes((ParameterizedAttribute)attr));
                    req.getDirectives().putAll(this.getDirectives((ParameterizedAttribute)attr));
                }
            }
            if ((providedCapabilities = metadata.getProvidedCapabilities()) != null && !providedCapabilities.isEmpty()) {
                for (ParameterizedAttribute attr : providedCapabilities) {
                    String capname = attr.getAttribute();
                    XCapability cap = this.addCapability(capname, null, null);
                    cap.getAttributes().putAll(this.getAttributes(attr));
                    cap.getDirectives().putAll(this.getDirectives(attr));
                }
            }
            if ((requiredCapabilities = metadata.getRequiredCapabilities()) != null && !requiredCapabilities.isEmpty()) {
                for (ParameterizedAttribute attr : requiredCapabilities) {
                    String reqname = attr.getAttribute();
                    req = this.addRequirement(reqname, null, null);
                    req.getAttributes().putAll(this.getAttributes(attr));
                    req.getDirectives().putAll(this.getDirectives(attr));
                }
            }
            this.resource.validate();
        }
        catch (ResourceValidationException ex) {
            throw ResolverMessages.MESSAGES.resourceBuilderCannotInitializeResource(ex, ex.getOffendingInput());
        }
        catch (RuntimeException ex) {
            throw ResolverMessages.MESSAGES.resourceBuilderCannotInitializeResource(ex, metadata.toString());
        }
        return this;
    }

    @Override
    public XResourceBuilder<T> loadFrom(Module module) throws ResourceBuilderException {
        this.assertResourceCreated();
        try {
            Version version;
            ModuleIdentifier moduleId = module.getIdentifier();
            String symbolicName = moduleId.getName();
            try {
                version = Version.parseVersion((String)moduleId.getSlot());
            }
            catch (IllegalArgumentException ex) {
                version = Version.emptyVersion;
            }
            XCapability icap = this.addCapability("osgi.identity", symbolicName);
            icap.getAttributes().put("version", version);
            icap.getAttributes().put("type", "module");
            XCapability bcap = this.addCapability("osgi.wiring.bundle", symbolicName);
            bcap.getAttributes().put("version", version);
            HashSet<String> paths = new HashSet<String>();
            Iterator it = module.getClassLoader().iterateResources("", true);
            while (it.hasNext()) {
                int index;
                Resource res = (Resource)it.next();
                String path = res.getName();
                if (!path.endsWith(".class") || (index = path.lastIndexOf("/")) <= 0 || paths.contains(path = path.substring(0, index))) continue;
                paths.add(path);
                String packageName = path.replace('/', '.');
                this.addCapability("osgi.wiring.package", packageName);
            }
            this.resource.validate();
        }
        catch (RuntimeException ex) {
            throw ResolverMessages.MESSAGES.resourceBuilderCannotInitializeResource(ex, this.resource.toString());
        }
        return this;
    }

    @Override
    public T getResource() {
        this.resource.validate();
        if (this.resource instanceof AbstractResource) {
            ((AbstractResource)this.resource).setMutable(false);
        }
        return this.resource;
    }

    private void addCapability(XCapability cap) {
        if (this.resource instanceof AbstractResource) {
            ((AbstractResource)this.resource).addCapability(cap);
        }
    }

    private void addRequirement(XRequirement req) {
        if (this.resource instanceof AbstractResource) {
            ((AbstractResource)this.resource).addRequirement(req);
        }
    }

    private Map<String, Object> getAttributes(ParameterizedAttribute patts) {
        LinkedHashMap<String, Object> atts = new LinkedHashMap<String, Object>();
        if (patts != null) {
            for (String key : patts.getAttributes().keySet()) {
                Parameter param = patts.getAttribute(key);
                atts.put(key, param.getValue());
            }
        }
        return atts;
    }

    private Map<String, String> getDirectives(ParameterizedAttribute patts) {
        LinkedHashMap<String, String> dirs = new LinkedHashMap<String, String>();
        if (patts != null) {
            for (String key : patts.getDirectives().keySet()) {
                String value = (String)patts.getDirectiveValue(key, String.class);
                dirs.put(key, value);
            }
        }
        return dirs;
    }

    private Map<String, Object> mutableAttributes(Map<String, Object> atts) {
        return new LinkedHashMap<String, Object>(atts != null ? atts : new LinkedHashMap());
    }

    private Map<String, String> mutableDirectives(Map<String, String> dirs) {
        return new LinkedHashMap<String, String>(dirs != null ? dirs : new LinkedHashMap());
    }

    private void assertResourceCreated() {
        if (this.resource == null) {
            throw ResolverMessages.MESSAGES.illegalStateResourceNotCreated();
        }
    }
}

