/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.deployment.deployer;

import java.io.Serializable;
import org.jboss.osgi.deployment.DeploymentMessages;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.spi.AttachableSupport;
import org.osgi.framework.Version;

public abstract class AbstractDeployment
extends AttachableSupport
implements Deployment,
Serializable {
    private static final long serialVersionUID = -3918766495938169718L;
    private String location;
    private String symbolicName;
    private String version;
    private Integer startLevel;
    private boolean autoStart;
    private boolean update;

    public AbstractDeployment(String location, String symbolicName, Version version) {
        if (location == null) {
            throw DeploymentMessages.MESSAGES.illegalArgumentNull("location");
        }
        if (version == null) {
            version = Version.emptyVersion;
        }
        this.location = location;
        this.symbolicName = symbolicName;
        this.version = version.toString();
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Integer getStartLevel() {
        return this.startLevel;
    }

    @Override
    public void setStartLevel(Integer startLevel) {
        if (startLevel == null || startLevel < 1) {
            throw DeploymentMessages.MESSAGES.illegalArgumentStartLevel(startLevel);
        }
        this.startLevel = startLevel;
    }

    @Override
    public boolean isAutoStart() {
        return this.autoStart;
    }

    @Override
    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    @Override
    public boolean isBundleUpdate() {
        return this.update;
    }

    @Override
    public void setBundleUpdate(boolean update) {
        this.update = update;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractDeployment)) {
            return false;
        }
        AbstractDeployment other = (AbstractDeployment)obj;
        boolean matchLocation = this.location.equals(other.location);
        boolean matchName = this.symbolicName == other.symbolicName || this.symbolicName.equals(other.symbolicName);
        boolean matchVersion = this.getVersion().equals(other.getVersion());
        return matchLocation && matchName && matchVersion;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "[" + this.symbolicName + ":" + this.version + ",location=" + this.location + "]";
    }
}

