/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.rest.integration;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.jboss.jbossts.star.logging.RESTATLogger;
import org.jboss.jbossts.star.util.TxStatus;
import org.jboss.jbossts.star.util.TxSupport;
import org.jboss.logging.Logger;
import org.jboss.narayana.rest.integration.ParticipantInformation;
import org.jboss.narayana.rest.integration.ParticipantsContainer;
import org.jboss.narayana.rest.integration.RecoveryManager;
import org.jboss.narayana.rest.integration.api.Aborted;
import org.jboss.narayana.rest.integration.api.HeuristicException;
import org.jboss.narayana.rest.integration.api.HeuristicType;
import org.jboss.narayana.rest.integration.api.ParticipantException;
import org.jboss.narayana.rest.integration.api.Prepared;
import org.jboss.narayana.rest.integration.api.ReadOnly;
import org.jboss.narayana.rest.integration.api.Vote;

@Path(value="rest-at-participant/{participantId}")
public final class ParticipantResource {
    public static final String BASE_PATH_SEGMENT = "rest-at-participant";
    private static final Logger LOG = Logger.getLogger(ParticipantResource.class);

    @HEAD
    public Response getTerminatorUrl(@PathParam(value="participantId") String participantId, @Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("HEAD request on ParticipantResource. ParticipantId: " + participantId));
        }
        if (ParticipantsContainer.getInstance().getParticipantInformation(participantId) == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Participant with id " + participantId + " was not found."));
            }
            return Response.status((int)404).build();
        }
        Response.ResponseBuilder builder = Response.ok();
        TxSupport.addLinkHeader((Response.ResponseBuilder)builder, (UriInfo)uriInfo, (String)"terminator", (String)"terminator", (String[])new String[0]);
        return builder.build();
    }

    @GET
    @Produces(value={"application/txstatus"})
    public Response getStatus(@PathParam(value="participantId") String participantId) {
        ParticipantInformation participantInformation;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("GET request on ParticipantResource. ParticipantId: " + participantId));
        }
        if ((participantInformation = ParticipantsContainer.getInstance().getParticipantInformation(participantId)) == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Participant with id " + participantId + " was not found."));
            }
            return Response.status((int)404).build();
        }
        return Response.ok((Object)TxSupport.toStatusContent((String)participantInformation.getStatus())).build();
    }

    @PUT
    @Consumes(value={"application/txstatus"})
    @Produces(value={"application/txstatus"})
    public Response terminate(@PathParam(value="participantId") String participantId, String content) throws HeuristicException {
        ParticipantInformation participantInformation;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("PUT request on ParticipantResource. ParticipantId: " + participantId + ", content: " + content));
        }
        if ((participantInformation = ParticipantsContainer.getInstance().getParticipantInformation(participantId)) == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Participant with id " + participantId + " was not found."));
            }
            return Response.status((int)404).build();
        }
        String status = TxSupport.getStatus((String)content);
        if (TxStatus.isPrepare((String)status)) {
            if (!this.canPrepare(participantInformation)) {
                return Response.status((int)412).build();
            }
            Vote vote = this.prepare(participantInformation);
            return this.voteToResponse(vote);
        }
        if (TxStatus.isCommit((String)status)) {
            if (!this.canCommit(participantInformation)) {
                return Response.status((int)412).build();
            }
            this.commit(participantInformation);
            return Response.ok().entity((Object)TxSupport.toStatusContent((String)TxStatus.TransactionCommitted.name())).build();
        }
        if (TxStatus.isCommitOnePhase((String)status)) {
            if (!this.canCommitOnePhase(participantInformation)) {
                return Response.status((int)412).build();
            }
            this.commitOnePhase(participantInformation);
            return Response.ok().entity((Object)TxSupport.toStatusContent((String)TxStatus.TransactionCommittedOnePhase.name())).build();
        }
        if (TxStatus.isAbort((String)status)) {
            this.rollback(participantInformation);
            return Response.ok().entity((Object)TxSupport.toStatusContent((String)TxStatus.TransactionRolledBack.name())).build();
        }
        return Response.status((int)400).build();
    }

    @DELETE
    public Response forgetHeuristic(@PathParam(value="participantId") String participantId) {
        ParticipantInformation participantInformation;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("DELETE request on ParticipantResource. ParticipantId: " + participantId));
        }
        if ((participantInformation = ParticipantsContainer.getInstance().getParticipantInformation(participantId)) == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Participant with id " + participantId + " was not found."));
            }
            return Response.status((int)404).build();
        }
        if (TxStatus.TransactionHeuristicCommit.name().equals(participantInformation.getStatus()) || TxStatus.TransactionHeuristicRollback.name().equals(participantInformation.getStatus()) || TxStatus.TransactionHeuristicHazard.name().equals(participantInformation.getStatus()) || TxStatus.TransactionHeuristicMixed.name().equals(participantInformation.getStatus())) {
            RecoveryManager.getInstance().removeParticipantInformation(participantInformation);
            ParticipantsContainer.getInstance().removeParticipantInformation(participantInformation.getId());
            return Response.ok().build();
        }
        return Response.status((int)412).build();
    }

    private Vote prepare(ParticipantInformation participantInformation) throws HeuristicException {
        Vote vote;
        if (this.isHeuristic(participantInformation)) {
            return this.prepareHeuristic(participantInformation);
        }
        participantInformation.setStatus(TxStatus.TransactionPreparing.name());
        try {
            vote = participantInformation.getParticipant().prepare();
        }
        catch (ParticipantException e) {
            if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                RESTATLogger.atI18NLogger.warn_prepareParticipantResource(e.getMessage(), (Throwable)e);
            }
            participantInformation.setStatus(TxStatus.TransactionActive.name());
            throw e;
        }
        if (vote instanceof Aborted) {
            this.rollback(participantInformation);
        } else if (vote instanceof Prepared) {
            participantInformation.setStatus(TxStatus.TransactionPrepared.name());
            RecoveryManager.getInstance().persistParticipantInformation(participantInformation);
        } else if (vote instanceof ReadOnly) {
            this.readOnly(participantInformation);
        }
        return vote;
    }

    private Vote prepareHeuristic(ParticipantInformation participantInformation) {
        if (TxStatus.TransactionHeuristicCommit.name().equals(participantInformation.getStatus())) {
            return new Prepared();
        }
        RecoveryManager.getInstance().removeParticipantInformation(participantInformation);
        return new Aborted();
    }

    private void commit(ParticipantInformation participantInformation) throws HeuristicException {
        if (this.isHeuristic(participantInformation)) {
            this.commitHeuristic(participantInformation);
        } else {
            participantInformation.setStatus(TxStatus.TransactionCommitting.name());
            try {
                participantInformation.getParticipant().commit();
            }
            catch (HeuristicException e) {
                if (!e.getHeuristicType().equals((Object)HeuristicType.HEURISTIC_COMMIT)) {
                    if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                        RESTATLogger.atI18NLogger.warn_heuristicRollbackParticipantResource(e.getMessage(), (Throwable)e);
                    }
                    participantInformation.setStatus(e.getHeuristicType().toTxStatus());
                    RecoveryManager.getInstance().persistParticipantInformation(participantInformation);
                    throw new HeuristicException(e.getHeuristicType());
                }
            }
            catch (ParticipantException e) {
                if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                    RESTATLogger.atI18NLogger.warn_participantRollbackParticipantResource(e.getMessage(), (Throwable)e);
                }
                participantInformation.setStatus(TxStatus.TransactionPrepared.name());
                throw e;
            }
            participantInformation.setStatus(TxStatus.TransactionCommitted.name());
            RecoveryManager.getInstance().removeParticipantInformation(participantInformation);
            ParticipantsContainer.getInstance().removeParticipantInformation(participantInformation.getId());
        }
    }

    private void commitHeuristic(ParticipantInformation participantInformation) throws HeuristicException {
        if (!TxStatus.TransactionHeuristicCommit.name().equals(participantInformation.getStatus())) {
            throw new HeuristicException(HeuristicType.fromTxStatus(participantInformation.getStatus()));
        }
        participantInformation.setStatus(TxStatus.TransactionCommitted.name());
        RecoveryManager.getInstance().removeParticipantInformation(participantInformation);
        ParticipantsContainer.getInstance().removeParticipantInformation(participantInformation.getId());
    }

    private void commitOnePhase(ParticipantInformation participantInformation) {
        if (!this.isHeuristic(participantInformation)) {
            participantInformation.setStatus(TxStatus.TransactionCommitting.name());
            try {
                participantInformation.getParticipant().commitOnePhase();
            }
            catch (ParticipantException e) {
                participantInformation.setStatus(TxStatus.TransactionActive.name());
                throw e;
            }
            participantInformation.setStatus(TxStatus.TransactionCommittedOnePhase.name());
            ParticipantsContainer.getInstance().removeParticipantInformation(participantInformation.getId());
        }
    }

    private void rollback(ParticipantInformation participantInformation) throws HeuristicException {
        if (this.isHeuristic(participantInformation)) {
            this.rollbackHeuristic(participantInformation);
        } else {
            String previousStatus = participantInformation.getStatus();
            participantInformation.setStatus(TxStatus.TransactionRollingBack.name());
            try {
                participantInformation.getParticipant().rollback();
            }
            catch (HeuristicException e) {
                if (!e.getHeuristicType().equals((Object)HeuristicType.HEURISTIC_ROLLBACK)) {
                    participantInformation.setStatus(e.getHeuristicType().toTxStatus());
                    RecoveryManager.getInstance().persistParticipantInformation(participantInformation);
                    throw new HeuristicException(e.getHeuristicType());
                }
            }
            catch (ParticipantException e) {
                participantInformation.setStatus(previousStatus);
                throw e;
            }
            participantInformation.setStatus(TxStatus.TransactionRolledBack.name());
            RecoveryManager.getInstance().removeParticipantInformation(participantInformation);
            ParticipantsContainer.getInstance().removeParticipantInformation(participantInformation.getId());
        }
    }

    private void rollbackHeuristic(ParticipantInformation participantInformation) throws HeuristicException {
        if (!TxStatus.TransactionHeuristicRollback.name().equals(participantInformation.getStatus())) {
            throw new HeuristicException(HeuristicType.fromTxStatus(participantInformation.getStatus()));
        }
        participantInformation.setStatus(TxStatus.TransactionRolledBack.name());
        RecoveryManager.getInstance().removeParticipantInformation(participantInformation);
        ParticipantsContainer.getInstance().removeParticipantInformation(participantInformation.getId());
    }

    private void readOnly(ParticipantInformation participantInformation) {
        participantInformation.setStatus(TxStatus.TransactionReadOnly.name());
        try {
            ClientBuilder.newClient().target(participantInformation.getRecoveryURL()).request().delete();
        }
        catch (Exception e) {
            RESTATLogger.atI18NLogger.warn_readOnlyParticipantResource(e.getMessage(), (Throwable)e);
        }
        ParticipantsContainer.getInstance().removeParticipantInformation(participantInformation.getId());
    }

    private Response voteToResponse(Vote vote) {
        Response response = vote instanceof Prepared ? Response.ok().entity((Object)TxSupport.toStatusContent((String)TxStatus.TransactionPrepared.name())).build() : (vote instanceof ReadOnly ? Response.ok().entity((Object)TxSupport.toStatusContent((String)TxStatus.TransactionReadOnly.name())).build() : Response.status((int)409).entity((Object)TxSupport.toStatusContent((String)TxStatus.TransactionRolledBack.name())).build());
        return response;
    }

    private boolean canPrepare(ParticipantInformation participantInformation) {
        return TxStatus.TransactionActive.name().equals(participantInformation.getStatus()) || this.isHeuristic(participantInformation);
    }

    private boolean canCommit(ParticipantInformation participantInformation) {
        return TxStatus.TransactionPrepared.name().equals(participantInformation.getStatus()) || this.isHeuristic(participantInformation);
    }

    private boolean canCommitOnePhase(ParticipantInformation participantInformation) {
        return TxStatus.TransactionActive.name().equals(participantInformation.getStatus()) || this.isHeuristic(participantInformation);
    }

    private boolean isHeuristic(ParticipantInformation participantInformation) {
        return TxStatus.TransactionHeuristicCommit.name().equals(participantInformation.getStatus()) || TxStatus.TransactionHeuristicRollback.name().equals(participantInformation.getStatus()) || TxStatus.TransactionHeuristicMixed.name().equals(participantInformation.getStatus()) || TxStatus.TransactionHeuristicHazard.name().equals(participantInformation.getStatus());
    }
}

