/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.mbeanserver;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    public static ClassLoader setContextClassLoader(final ClassLoader cl) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return SecurityActions.doSetContextClassLoader(cl);
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return SecurityActions.doSetContextClassLoader(cl);
            }
        });
    }

    private static ClassLoader doSetContextClassLoader(ClassLoader cl) {
        Thread thread = Thread.currentThread();
        ClassLoader previous = thread.getContextClassLoader();
        thread.setContextClassLoader(cl);
        return previous;
    }
}

