/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import java.util.Collection;

public interface ClassTransformer {
    public static final ClassTransformer IDENTITY = new ClassTransformer(){

        @Override
        public ByteBuffer transform(ClassLoader loader, String className, ProtectionDomain protectionDomain, ByteBuffer classBytes) throws IllegalArgumentException {
            return classBytes;
        }

        @Override
        public ClassTransformer andThen(ClassTransformer other) {
            if (other == null) {
                throw new IllegalArgumentException("other is null");
            }
            return other;
        }
    };

    public ByteBuffer transform(ClassLoader var1, String var2, ProtectionDomain var3, ByteBuffer var4) throws IllegalArgumentException;

    default public ClassTransformer andThen(final ClassTransformer other) {
        if (other == null) {
            throw new IllegalArgumentException("other is null");
        }
        if (other == IDENTITY) {
            return this;
        }
        return new ClassTransformer(){
            final /* synthetic */ ClassTransformer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ByteBuffer transform(ClassLoader loader, String className, ProtectionDomain protectionDomain, ByteBuffer classBytes) throws IllegalArgumentException {
                ByteBuffer firstStage = this.this$0.transform(loader, className, protectionDomain, classBytes);
                if (firstStage == null) {
                    firstStage = classBytes;
                }
                return other.transform(loader, className, protectionDomain, firstStage);
            }
        };
    }

    public static ClassTransformer allOf(final Collection<? extends ClassTransformer> transformers) {
        if (transformers == null) {
            throw new IllegalArgumentException("transformers is null");
        }
        return new ClassTransformer(){

            @Override
            public ByteBuffer transform(ClassLoader loader, String className, ProtectionDomain protectionDomain, ByteBuffer classBytes) throws IllegalArgumentException {
                for (ClassTransformer transformer : transformers) {
                    ByteBuffer transformed;
                    if (transformer == null || (transformed = transformer.transform(loader, className, protectionDomain, classBytes)) == null) continue;
                    classBytes = transformed;
                }
                return classBytes;
            }
        };
    }
}

