/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import org.jboss.modules.Dependency;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleDependency;
import org.jboss.modules.ModuleDependencySpecBuilder;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.Utils;
import org.jboss.modules.filter.ClassFilter;
import org.jboss.modules.filter.PathFilter;

public final class ModuleDependencySpec
extends DependencySpec {
    public static final ModuleDependencySpec JAVA_BASE = new ModuleDependencySpecBuilder().setModuleLoader(Utils.JDK_MODULE_LOADER).setName("java.base").build();
    public static final ModuleDependencySpec JAVA_SE = new ModuleDependencySpecBuilder().setModuleLoader(Utils.JDK_MODULE_LOADER).setName("java.se").build();
    private final ModuleLoader moduleLoader;
    private final String name;
    private final boolean optional;

    ModuleDependencySpec(PathFilter importFilter, PathFilter exportFilter, PathFilter resourceImportFilter, PathFilter resourceExportFilter, ClassFilter classImportFilter, ClassFilter classExportFilter, ModuleLoader moduleLoader, String name, boolean optional) {
        super(importFilter, exportFilter, resourceImportFilter, resourceExportFilter, classImportFilter, classExportFilter);
        this.moduleLoader = moduleLoader;
        this.name = name;
        this.optional = optional;
    }

    @Override
    Dependency getDependency(Module module) {
        ModuleLoader loader = this.moduleLoader;
        return new ModuleDependency(this.exportFilter, this.importFilter, this.resourceExportFilter, this.resourceImportFilter, this.classExportFilter, this.classImportFilter, loader == null ? module.getModuleLoader() : loader, this.name, this.optional);
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public String getName() {
        return this.name;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String toString() {
        return "dependency on " + this.name;
    }
}

