/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.JDKPaths;
import org.jboss.modules.JarFileResourceLoader;
import org.jboss.modules.ModuleDependencySpecBuilder;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.PathResourceLoader;
import org.jboss.modules.PathUtils;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.Utils;
import org.jboss.modules.filter.MultiplePathFilterBuilder;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.xml.ModuleXmlParser;

@Deprecated
public final class JarModuleFinder
implements ModuleFinder {
    private final String myName;
    private final JarFile jarFile;
    private final AccessControlContext context;

    public JarModuleFinder(String myName, JarFile jarFile) {
        this.myName = myName;
        this.jarFile = jarFile;
        this.context = AccessController.getContext();
    }

    @Override
    public ModuleSpec findModule(String name, ModuleLoader delegateLoader) throws ModuleLoadException {
        ModuleSpec moduleSpec;
        if (name.equals(this.myName)) {
            String[] dependencyEntries;
            String[] classPathEntries;
            Manifest manifest;
            try {
                manifest = this.jarFile.getManifest();
            }
            catch (IOException e) {
                throw new ModuleLoadException("Failed to load MANIFEST from JAR", e);
            }
            ModuleSpec.Builder builder = ModuleSpec.build(name);
            Attributes mainAttributes = manifest.getMainAttributes();
            String mainClass = mainAttributes.getValue(Attributes.Name.MAIN_CLASS);
            if (mainClass != null) {
                builder.setMainClass(mainClass);
            }
            String classPath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
            String dependencies = mainAttributes.getValue("Dependencies");
            MultiplePathFilterBuilder pathFilterBuilder = PathFilters.multiplePathFilterBuilder(true);
            pathFilterBuilder.addFilter(PathFilters.is("modules"), false);
            pathFilterBuilder.addFilter(PathFilters.isChildOf("modules"), false);
            builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(new JarFileResourceLoader("", this.jarFile), pathFilterBuilder.create()));
            for (String entry : classPathEntries = classPath == null ? Utils.NO_STRINGS : classPath.split("\\s+")) {
                JarFile childJarFile;
                File root;
                if (entry.isEmpty() || entry.startsWith("../") || entry.startsWith("./") || entry.startsWith("/") || entry.contains("/../")) continue;
                try {
                    File path = new File(new URI(entry));
                    root = path.isAbsolute() ? path : new File(this.jarFile.getName(), path.getPath());
                }
                catch (URISyntaxException e) {
                    root = new File(this.jarFile.getName(), entry);
                }
                if (entry.endsWith("/")) {
                    builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(new PathResourceLoader(entry, root.toPath(), this.context)));
                    continue;
                }
                try {
                    childJarFile = new JarFile(root, true, 1, JarFile.runtimeVersion());
                }
                catch (IOException e) {
                    continue;
                }
                builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(new JarFileResourceLoader(entry, childJarFile)));
            }
            for (String dependencyEntry : dependencyEntries = dependencies == null ? Utils.NO_STRINGS : dependencies.split("\\s*,\\s*")) {
                String[] fields;
                boolean optional = false;
                boolean export = false;
                if ((dependencyEntry = dependencyEntry.trim()).isEmpty() || (fields = dependencyEntry.split("\\s+")).length < 1) continue;
                String moduleName = fields[0];
                for (int i = 1; i < fields.length; ++i) {
                    String field = fields[i];
                    if (field.equals("optional")) {
                        optional = true;
                        continue;
                    }
                    if (!field.equals("export")) continue;
                    export = true;
                }
                builder.addDependency(new ModuleDependencySpecBuilder().setName(moduleName).setExport(export).setOptional(optional).build());
            }
            builder.addDependency(DependencySpec.createSystemDependencySpec(JDKPaths.JDK));
            builder.addDependency(DependencySpec.createLocalDependencySpec());
            return builder.create();
        }
        String path = PathUtils.basicModuleNameToPath(name);
        if (path == null) {
            return null;
        }
        String basePath = "modules/" + path;
        JarEntry moduleXmlEntry = this.jarFile.getJarEntry(basePath + "/module.xml");
        if (moduleXmlEntry == null) {
            return null;
        }
        try (InputStream inputStream = this.jarFile.getInputStream(moduleXmlEntry);){
            moduleSpec = ModuleXmlParser.parseModuleXml((rootPath, loaderPath, loaderName) -> new JarFileResourceLoader(loaderName, this.jarFile, loaderPath), basePath, inputStream, moduleXmlEntry.getName(), delegateLoader, name);
        }
        catch (IOException e) {
            throw new ModuleLoadException("Failed to read module.xml file", e);
        }
        return moduleSpec;
    }
}

