/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.util.jar.JarFile;
import org.jboss.modules.JarModuleFinder;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

final class JarModuleLoader
extends ModuleLoader {
    static final String[] NO_STRINGS = new String[0];
    private final ModuleLoader delegate;
    private final JarFile jarFile;
    private final String myName;

    JarModuleLoader(ModuleLoader delegate, JarFile jarFile) {
        super(new ModuleFinder[]{new JarModuleFinder(JarModuleLoader.simpleNameOf(jarFile), jarFile)});
        this.delegate = delegate;
        this.jarFile = jarFile;
        this.myName = JarModuleLoader.simpleNameOf(jarFile);
    }

    private static String simpleNameOf(JarFile jarFile) {
        String jarName = jarFile.getName();
        String simpleJarName = jarName.substring(jarName.lastIndexOf(File.separatorChar) + 1);
        return simpleJarName;
    }

    @Override
    protected Module preloadModule(String name) throws ModuleLoadException {
        if (name.equals(this.myName)) {
            return this.loadModuleLocal(name);
        }
        Module module = this.loadModuleLocal(name);
        if (module == null) {
            return JarModuleLoader.preloadModule(name, this.delegate);
        }
        return module;
    }

    String getMyName() {
        return this.myName;
    }

    @Override
    public String toString() {
        return "JAR module loader";
    }
}

