/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessControlContext;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.modules.PathResourceLoader;
import org.jboss.modules.ResourceLoaders;

final class FileResourceLoader
extends PathResourceLoader {
    FileResourceLoader(String rootName, File root, AccessControlContext context) {
        super(rootName, root.toPath(), context);
    }

    @Override
    public Collection<String> getPaths() {
        new ArrayList();
        Path indexFile = this.root.resolveSibling(this.root.getFileName() + ".index");
        if (ResourceLoaders.USE_INDEXES && Files.exists(indexFile, new LinkOption[0])) {
            try {
                return Files.readAllLines(indexFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Collection<String> index = super.getPaths();
        if (ResourceLoaders.WRITE_INDEXES) {
            try {
                Files.write(indexFile, index, new OpenOption[0]);
            }
            catch (Exception e) {
                try {
                    Files.deleteIfExists(indexFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return index;
    }
}

