/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.security.AccessController;
import java.util.Arrays;
import java.util.Deque;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ModuleLoggerFinder
extends System.LoggerFinder {
    private static final System.LoggerFinder queueingFinder = new System.LoggerFinder(){

        @Override
        public System.Logger getLogger(String name, Module module) {
            return new DelegatingSystemLogger(new QueueingSystemLogger(name, module));
        }
    };
    private static final Supplier<System.LoggerFinder> defaultFinder = () -> new System.LoggerFinder(){

        @Override
        public System.Logger getLogger(String name, Module module) {
            return new JulSystemLogger(Logger.getLogger(name));
        }
    };
    private static final Map<String, System.Logger> loggers = new ConcurrentHashMap<String, System.Logger>();
    private static final ReentrantLock lock = new ReentrantLock();
    private static final Deque<SystemLogRecord> messages = new LinkedBlockingDeque<SystemLogRecord>();
    private static volatile boolean activated = false;
    private static volatile System.LoggerFinder finder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public System.Logger getLogger(String name, Module module) {
        if (activated) {
            return finder.getLogger(name, module);
        }
        lock.lock();
        try {
            if (activated) {
                System.Logger logger = finder.getLogger(name, module);
                return logger;
            }
            System.Logger logger = loggers.computeIfAbsent(name, s -> queueingFinder.getLogger(name, module));
            return logger;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void activate(ClassLoader cl) {
        lock.lock();
        try {
            SystemLogRecord record;
            if (!activated) {
                try {
                    ServiceLoader<System.LoggerFinder> loader = ServiceLoader.load(System.LoggerFinder.class, cl == null ? ClassLoader.getSystemClassLoader() : cl);
                    for (System.LoggerFinder lf : loader) {
                        if (ModuleLoggerFinder.class.equals(lf.getClass())) continue;
                        finder = lf;
                        break;
                    }
                    if (finder == null) {
                        finder = defaultFinder.get();
                    }
                }
                catch (Throwable ignore) {
                    finder = defaultFinder.get();
                }
                Iterator<Map.Entry<String, System.Logger>> iter = loggers.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<String, System.Logger> entry = iter.next();
                    System.Logger currentLogger = entry.getValue();
                    DelegatingSystemLogger delegatingSystemLogger = (DelegatingSystemLogger)currentLogger;
                    System.Logger currentDelegate = delegatingSystemLogger.getDelegate();
                    QueueingSystemLogger queueingSystemLogger = (QueueingSystemLogger)currentDelegate;
                    delegatingSystemLogger.delegate.compareAndSet(currentDelegate, finder.getLogger(queueingSystemLogger.name, queueingSystemLogger.module));
                    iter.remove();
                }
            }
            while ((record = messages.pollFirst()) != null) {
                System.Logger logger = finder.getLogger(record.name, record.module);
                try {
                    if (record.cause == null) {
                        logger.log(record.level, record.bundle, record.msg, record.params);
                        continue;
                    }
                    logger.log(record.level, record.bundle, record.msg, record.cause);
                }
                catch (Exception e) {
                    System.err.printf("Failed to log message: %s%n", record);
                    e.printStackTrace(System.err);
                }
            }
        }
        finally {
            activated = true;
            lock.unlock();
        }
    }

    private static class SystemLogRecord {
        private final String name;
        private final Module module;
        private final System.Logger.Level level;
        private final ResourceBundle bundle;
        private final String msg;
        private final Object[] params;
        private final Throwable cause;

        private SystemLogRecord(String name, Module module, System.Logger.Level level, ResourceBundle bundle, String msg, Object[] params, Throwable cause) {
            this.name = name;
            this.module = module;
            this.level = level;
            this.bundle = bundle;
            this.msg = msg;
            this.params = params == null ? null : Arrays.copyOf(params, params.length);
            this.cause = cause;
        }

        public String toString() {
            return "SystemLogRecord(level=" + this.level + ", bundle=" + this.bundle + ", msg=" + this.msg + ", params=" + (this.params == null ? "" : Arrays.toString(this.params)) + ", cause=" + this.cause + ")";
        }
    }

    private static class QueueingSystemLogger
    implements System.Logger {
        private static final System.Logger.Level DEFAULT_LEVEL;
        private final String name;
        private final Module module;

        private QueueingSystemLogger(String name, Module module) {
            this.name = name;
            this.module = module;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isLoggable(System.Logger.Level level) {
            return level != System.Logger.Level.OFF && level.ordinal() >= DEFAULT_LEVEL.ordinal();
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
            messages.addLast(new SystemLogRecord(this.name, this.module, level, bundle, msg, null, thrown));
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
            messages.addLast(new SystemLogRecord(this.name, this.module, level, bundle, format, params, null));
        }

        static {
            System.Logger.Level level;
            if (System.getSecurityManager() == null) {
                try {
                    level = System.Logger.Level.valueOf(System.getProperty("jdk.system.logger.level", "INFO"));
                }
                catch (IllegalArgumentException ignore) {
                    level = System.Logger.Level.INFO;
                }
            } else {
                level = AccessController.doPrivileged(() -> {
                    try {
                        return System.Logger.Level.valueOf(System.getProperty("jdk.system.logger.level", "INFO"));
                    }
                    catch (IllegalArgumentException ignore) {
                        return System.Logger.Level.INFO;
                    }
                });
            }
            DEFAULT_LEVEL = level;
        }
    }

    private static class JulSystemLogger
    implements System.Logger {
        private static final Map<System.Logger.Level, Level> LEVELS = new EnumMap<System.Logger.Level, Level>(System.Logger.Level.class);
        private final Logger delegate;

        private JulSystemLogger(Logger delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public boolean isLoggable(System.Logger.Level level) {
            return this.delegate.isLoggable(LEVELS.getOrDefault((Object)level, Level.INFO));
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
            this.delegate.logrb(LEVELS.getOrDefault((Object)level, Level.INFO), bundle, msg, thrown);
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
            this.delegate.logrb(LEVELS.getOrDefault((Object)level, Level.INFO), bundle, format, params);
        }

        static {
            LEVELS.put(System.Logger.Level.ALL, Level.ALL);
            LEVELS.put(System.Logger.Level.TRACE, Level.FINER);
            LEVELS.put(System.Logger.Level.DEBUG, Level.FINE);
            LEVELS.put(System.Logger.Level.INFO, Level.INFO);
            LEVELS.put(System.Logger.Level.WARNING, Level.WARNING);
            LEVELS.put(System.Logger.Level.ERROR, Level.SEVERE);
            LEVELS.put(System.Logger.Level.OFF, Level.OFF);
        }
    }

    private static class DelegatingSystemLogger
    implements System.Logger {
        private final AtomicReference<System.Logger> delegate;

        private DelegatingSystemLogger(System.Logger delegate) {
            this.delegate = new AtomicReference<System.Logger>(delegate);
        }

        @Override
        public String getName() {
            return this.getDelegate().getName();
        }

        @Override
        public boolean isLoggable(System.Logger.Level level) {
            return this.getDelegate().isLoggable(level);
        }

        @Override
        public void log(System.Logger.Level level, String msg) {
            this.getDelegate().log(level, msg);
        }

        @Override
        public void log(System.Logger.Level level, Supplier<String> msgSupplier) {
            this.getDelegate().log(level, msgSupplier);
        }

        @Override
        public void log(System.Logger.Level level, Object obj) {
            this.getDelegate().log(level, obj);
        }

        @Override
        public void log(System.Logger.Level level, String msg, Throwable thrown) {
            this.getDelegate().log(level, msg, thrown);
        }

        @Override
        public void log(System.Logger.Level level, Supplier<String> msgSupplier, Throwable thrown) {
            this.getDelegate().log(level, msgSupplier, thrown);
        }

        @Override
        public void log(System.Logger.Level level, String format, Object ... params) {
            this.getDelegate().log(level, format, params);
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
            this.getDelegate().log(level, bundle, msg, thrown);
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
            this.getDelegate().log(level, bundle, format, params);
        }

        private System.Logger getDelegate() {
            return this.delegate.get();
        }
    }
}

