/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.modules.Dependency;
import org.jboss.modules.LocalLoader;

final class Linkage {
    private static final Dependency[] NO_DEPENDENCIES = new Dependency[0];
    private final Dependency[] sourceList;
    private final State state;
    private final Map<String, List<LocalLoader>> allPaths;
    private final Map<String, List<LocalLoader>> exportedPaths;
    static final Linkage NONE = new Linkage(NO_DEPENDENCIES, State.NEW, Collections.<String, List<LocalLoader>>emptyMap(), Collections.<String, List<LocalLoader>>emptyMap());

    Linkage(Dependency[] sourceList, State state) {
        this(sourceList, state, Collections.emptyMap(), Collections.emptyMap());
    }

    Linkage(Dependency[] sourceList, State state, Map<String, List<LocalLoader>> allPaths, Map<String, List<LocalLoader>> exportedPaths) {
        this.sourceList = sourceList;
        this.state = state;
        this.allPaths = allPaths;
        this.exportedPaths = exportedPaths;
    }

    Map<String, List<LocalLoader>> getAllPaths() {
        return this.allPaths;
    }

    Map<String, List<LocalLoader>> getExportedPaths() {
        return this.exportedPaths;
    }

    Map<String, List<LocalLoader>> getPaths(boolean export) {
        return export ? this.exportedPaths : this.allPaths;
    }

    State getState() {
        return this.state;
    }

    Dependency[] getSourceList() {
        return this.sourceList;
    }

    static enum State {
        NEW,
        UNLINKED,
        LINKING,
        LINKED;

    }
}

