/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules.ref;

import java.lang.ref.ReferenceQueue;
import org.jboss.modules.ref.PhantomReference;
import org.jboss.modules.ref.Reapable;
import org.jboss.modules.ref.Reaper;
import org.jboss.modules.ref.Reference;
import org.jboss.modules.ref.SoftReference;
import org.jboss.modules.ref.StrongReference;
import org.jboss.modules.ref.WeakReference;

public final class References {
    private static final Reference NULL = new Reference(){

        public Object get() {
            return null;
        }

        public Object getAttachment() {
            return null;
        }

        @Override
        public void clear() {
        }

        @Override
        public Reference.Type getType() {
            return Reference.Type.NULL;
        }

        public String toString() {
            return "NULL reference";
        }
    };

    private References() {
    }

    public static <T, A> Reference<T, A> create(Reference.Type type, T value, A attachment, Reaper<T, A> reaper) {
        switch (type) {
            case STRONG: {
                return new StrongReference<T, A>(value, attachment);
            }
            case WEAK: {
                return new WeakReference<T, A>(value, attachment, reaper);
            }
            case PHANTOM: {
                return new PhantomReference<T, A>(value, attachment, reaper);
            }
            case SOFT: {
                return new SoftReference<T, A>(value, attachment, reaper);
            }
            case NULL: {
                return References.getNullReference();
            }
        }
        throw new IllegalStateException();
    }

    public static <T, A> Reference<T, A> create(Reference.Type type, T value, A attachment, ReferenceQueue<? super T> referenceQueue) {
        switch (type) {
            case STRONG: {
                return new StrongReference<T, A>(value, attachment);
            }
            case WEAK: {
                return new WeakReference<T, A>(value, attachment, referenceQueue);
            }
            case PHANTOM: {
                return new PhantomReference<T, A>(value, attachment, referenceQueue);
            }
            case SOFT: {
                return new SoftReference<T, A>(value, attachment, referenceQueue);
            }
            case NULL: {
                return References.getNullReference();
            }
        }
        throw new IllegalStateException();
    }

    public static <T, A> Reference<T, A> create(Reference.Type type, T value, A attachment) throws IllegalArgumentException {
        switch (type) {
            case STRONG: {
                return new StrongReference<T, A>(value, attachment);
            }
            case WEAK: {
                return new WeakReference<T, A>(value, attachment);
            }
            case PHANTOM: {
                throw new IllegalArgumentException("Phantom reference may not be created without a queue or reaper");
            }
            case SOFT: {
                return new SoftReference<T, A>(value, attachment);
            }
            case NULL: {
                return References.getNullReference();
            }
        }
        throw new IllegalStateException();
    }

    public static <T, A> Reference<T, A> getNullReference() {
        return NULL;
    }

    static final class ReaperThread
    extends Thread {
        static final ReferenceQueue<Object> REAPER_QUEUE = new ReferenceQueue();

        ReaperThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        java.lang.ref.Reference<Object> ref;
                        if (!((ref = REAPER_QUEUE.remove()) instanceof Reapable)) {
                            continue;
                        }
                        ReaperThread.reap((Reapable)((Object)ref));
                    }
                }
                catch (InterruptedException ignored) {}
                finally {
                    continue;
                }
                break;
            }
        }

        private static <T, A> void reap(Reapable<T, A> reapable) {
            reapable.getReaper().reap((Reference)((Object)reapable));
        }

        static {
            ReaperThread thr = new ReaperThread();
            thr.setName("Reference Reaper");
            thr.setDaemon(true);
            thr.start();
        }
    }
}

