/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.util.Collection;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.filter.PathFilter;

final class FilteredResourceLoader
implements ResourceLoader {
    private final PathFilter filter;
    private final ResourceLoader loader;

    FilteredResourceLoader(PathFilter filter, ResourceLoader loader) {
        this.filter = filter;
        this.loader = loader;
    }

    @Override
    public String getRootName() {
        return this.loader.getRootName();
    }

    @Override
    public ClassSpec getClassSpec(String fileName) throws IOException {
        return this.filter.accept(fileName) ? this.loader.getClassSpec(fileName) : null;
    }

    @Override
    public PackageSpec getPackageSpec(String name) throws IOException {
        return this.loader.getPackageSpec(name);
    }

    @Override
    public Resource getResource(String name) {
        return this.filter.accept(name) ? this.loader.getResource(name) : null;
    }

    @Override
    public String getLibrary(String name) {
        return this.loader.getLibrary(name);
    }

    @Override
    public Collection<String> getPaths() {
        return this.loader.getPaths();
    }
}

