/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ModuleXmlParser;
import org.jboss.modules.SystemModuleLoader;

public final class LocalModuleLoader
extends ModuleLoader {
    private final File[] repoRoots;
    private final String name;

    public LocalModuleLoader(String name, File[] repoRoots) {
        this.repoRoots = repoRoots;
        this.name = name;
    }

    @Override
    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        if (identifier.equals(ModuleIdentifier.SYSTEM)) {
            return LocalModuleLoader.preloadModule(ModuleIdentifier.SYSTEM, SystemModuleLoader.getInstance());
        }
        return super.preloadModule(identifier);
    }

    @Override
    protected ModuleSpec findModule(ModuleIdentifier moduleIdentifier) throws ModuleLoadException {
        File moduleRoot = this.getModuleRoot(moduleIdentifier);
        if (moduleRoot == null) {
            throw new ModuleNotFoundException("Module " + moduleIdentifier + " is not found");
        }
        File moduleXml = new File(moduleRoot, "module.xml");
        return this.parseModuleInfoFile(moduleIdentifier, moduleRoot, moduleXml);
    }

    private File getModuleRoot(ModuleIdentifier moduleIdentifier) {
        String child = LocalModuleLoader.toPathString(moduleIdentifier);
        for (File root : this.repoRoots) {
            File file = new File(root, child);
            if (!file.exists() || !new File(file, "module.xml").exists()) continue;
            return file;
        }
        return null;
    }

    private static String toPathString(ModuleIdentifier moduleIdentifier) {
        StringBuilder builder = new StringBuilder();
        builder.append(moduleIdentifier.getName().replace('.', File.separatorChar));
        builder.append(File.separatorChar).append(moduleIdentifier.getSlot());
        builder.append(File.separatorChar);
        return builder.toString();
    }

    private ModuleSpec parseModuleInfoFile(ModuleIdentifier moduleIdentifier, File moduleRoot, File moduleInfoFile) throws ModuleLoadException {
        return ModuleXmlParser.parse(moduleIdentifier, moduleRoot, moduleInfoFile);
    }

    @Override
    public String toString() {
        return this.name;
    }
}

