/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.modules.AggregatePathFilter;
import org.jboss.modules.BooleanPathFilter;
import org.jboss.modules.GlobPathFilter;
import org.jboss.modules.InvertingPathFilter;
import org.jboss.modules.PathFilter;
import org.jboss.modules.SetPathFilter;

public final class PathFilters {
    private PathFilters() {
    }

    public static PathFilter all(PathFilter ... filters) {
        return new AggregatePathFilter(false, filters);
    }

    public static PathFilter all(Collection<PathFilter> filters) {
        return PathFilters.all(filters.toArray(new PathFilter[filters.size()]));
    }

    public static PathFilter any(PathFilter ... filters) {
        return new AggregatePathFilter(true, filters);
    }

    public static PathFilter any(Collection<PathFilter> filters) {
        return PathFilters.any(filters.toArray(new PathFilter[filters.size()]));
    }

    public static PathFilter not(PathFilter filter) {
        return new InvertingPathFilter(filter);
    }

    public static PathFilter include(String glob) {
        return new GlobPathFilter(true, glob);
    }

    public static PathFilter include(Pattern pattern) {
        return new GlobPathFilter(true, pattern, null);
    }

    public static PathFilter exclude(String glob) {
        return new GlobPathFilter(false, glob);
    }

    public static PathFilter exclude(Pattern pattern) {
        return new GlobPathFilter(false, pattern, null);
    }

    public static PathFilter acceptAll() {
        return BooleanPathFilter.TRUE;
    }

    public static PathFilter rejectAll() {
        return BooleanPathFilter.FALSE;
    }

    public static PathFilter in(Set<String> paths) {
        return new SetPathFilter(new HashSet<String>(paths));
    }
}

