/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.modules.AssertionSetting;
import org.jboss.modules.ConcurrentClassLoader;
import org.jboss.modules.Dependency;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.DependencyVisitor;
import org.jboss.modules.InitialModuleLoader;
import org.jboss.modules.LocalDependency;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.ModularURLStreamHandlerFactory;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleClassLoaderFactory;
import org.jboss.modules.ModuleDependency;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleLoaderSelector;
import org.jboss.modules.ModuleLogger;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.NoopModuleLogger;
import org.jboss.modules.PathFilter;
import org.jboss.modules.PathFilters;
import org.jboss.modules.Paths;
import org.jboss.modules.Resource;
import org.jboss.modules.SystemLocalLoader;

public final class Module {
    static volatile ModuleLogger log;
    private static volatile ModuleLoaderSelector moduleLoaderSelector;
    private final ModuleIdentifier identifier;
    private final String mainClassName;
    private final ModuleClassLoader moduleClassLoader;
    private final ModuleLoader moduleLoader;
    private final Object myKey;
    private final LocalLoader fallbackLoader;
    private static final Dependency[] NO_DEPENDENCIES;
    private volatile Paths<LocalLoader, Dependency> paths = Paths.none();
    private static final AtomicReferenceFieldUpdater<Module, Paths<LocalLoader, Dependency>> pathsUpdater;
    private volatile LoadState loadState = LoadState.LOADED;
    private static final AtomicReferenceFieldUpdater<Module, LoadState> loadStateUpdater;
    private static final RuntimePermission GET_CLASS_LOADER;

    private static <A, B> AtomicReferenceFieldUpdater<A, B> unsafeCast(AtomicReferenceFieldUpdater<?, ?> updater) {
        return updater;
    }

    private Module() {
        this.moduleLoader = InitialModuleLoader.INSTANCE;
        this.identifier = ModuleIdentifier.SYSTEM;
        this.mainClassName = null;
        this.myKey = null;
        this.fallbackLoader = null;
        this.moduleClassLoader = new ModuleClassLoader(new ModuleClassLoader.Configuration(this, AssertionSetting.INHERIT, ModuleClassLoader.NO_RESOURCE_LOADERS));
    }

    Module(ModuleSpec spec, ModuleLoader moduleLoader, Object myKey) {
        this.moduleLoader = moduleLoader;
        this.myKey = myKey;
        this.identifier = spec.getModuleIdentifier();
        this.mainClassName = spec.getMainClass();
        this.fallbackLoader = spec.getFallbackLoader();
        ModuleClassLoader.Configuration configuration = new ModuleClassLoader.Configuration(this, spec.getAssertionSetting(), spec.getResourceLoaders());
        ModuleClassLoaderFactory factory = spec.getModuleClassLoaderFactory();
        ModuleClassLoader moduleClassLoader = null;
        if (factory != null) {
            moduleClassLoader = factory.create(configuration);
        }
        if (moduleClassLoader == null) {
            moduleClassLoader = new ModuleClassLoader(configuration);
        }
        this.moduleClassLoader = moduleClassLoader;
    }

    private void resolveInitial() throws ModuleLoadException {
        if (this.loadState.compareTo(LoadState.RESOLVED) >= 0) {
            return;
        }
        this.resolve();
    }

    void resolve() throws ModuleLoadException {
        this.resolve(new HashSet<Module>());
    }

    private void setDependencies(Dependency[] dependencies) throws ModuleLoadException {
        this.setDependencies(new HashSet<Module>(), this.paths, dependencies);
    }

    private void resolve(Set<Module> visited) throws ModuleLoadException {
        Paths<LocalLoader, Dependency> paths = this.paths;
        this.setDependencies(visited, paths, paths.getSourceList((Dependency[])NO_DEPENDENCIES));
    }

    private void setDependencies(final Set<Module> visited, Paths<LocalLoader, Dependency> paths, Dependency[] dependencies) throws ModuleLoadException {
        if (!visited.add(this)) {
            return;
        }
        final ArrayDeque filterSeries = new ArrayDeque();
        final HashMap allPaths = new HashMap();
        final HashMap exportedPaths = new HashMap();
        final DependencyVisitor<PathFilter> distantVisitor = new DependencyVisitor<PathFilter>(){

            @Override
            public void visit(LocalDependency item, PathFilter firstExportFilter) throws ModuleLoadException {
                Set<String> paths = item.getPaths();
                PathFilter importFilter = item.getImportFilter();
                PathFilter exportFilter = item.getExportFilter();
                LocalLoader loader = item.getLocalLoader();
                block0: for (String path : paths) {
                    if (!importFilter.accept(path) || !exportFilter.accept(path)) continue;
                    for (PathFilter filter : filterSeries) {
                        if (filter.accept(path)) continue;
                        continue block0;
                    }
                    Module.addToMapList(allPaths, path, loader);
                    if (!firstExportFilter.accept(path)) continue;
                    Module.addToMapList(exportedPaths, path, loader);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit(ModuleDependency item, PathFilter firstExportFilter) throws ModuleLoadException {
                Module module = item.getModuleRequired();
                if (module == null) {
                    return;
                }
                if (!visited.add(module)) {
                    return;
                }
                PathFilter exportFilter = item.getExportFilter();
                if (exportFilter == PathFilters.rejectAll()) {
                    return;
                }
                filterSeries.addLast(item.getImportFilter());
                filterSeries.addLast(exportFilter);
                try {
                    for (Dependency dep : module.getDependencies()) {
                        dep.accept(this, firstExportFilter);
                    }
                }
                finally {
                    filterSeries.removeLast();
                    filterSeries.removeLast();
                }
            }
        };
        DependencyVisitor<Void> nearVisitor = new DependencyVisitor<Void>(){

            @Override
            public void visit(LocalDependency item, Void param) throws ModuleLoadException {
                Set<String> paths = item.getPaths();
                PathFilter importFilter = item.getImportFilter();
                PathFilter exportFilter = item.getExportFilter();
                LocalLoader loader = item.getLocalLoader();
                for (String path : paths) {
                    if (!importFilter.accept(path)) continue;
                    Module.addToMapList(allPaths, path, loader);
                    if (!exportFilter.accept(path)) continue;
                    Module.addToMapList(exportedPaths, path, loader);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visit(ModuleDependency item, Void param) throws ModuleLoadException {
                Module module = item.getModuleRequired();
                if (module == null) {
                    return;
                }
                filterSeries.addLast(item.getImportFilter());
                PathFilter exportFilter = item.getExportFilter();
                try {
                    for (Dependency dep : module.getDependencies()) {
                        dep.accept(distantVisitor, exportFilter);
                    }
                }
                finally {
                    filterSeries.removeLast();
                }
            }
        };
        for (Dependency dependency : dependencies) {
            dependency.accept(nearVisitor, null);
        }
        pathsUpdater.compareAndSet(this, paths, new Paths(dependencies, allPaths, exportedPaths));
        loadStateUpdater.compareAndSet(this, LoadState.LOADED, LoadState.RESOLVED);
    }

    Dependency[] getDependencies() {
        return this.paths.getSourceList((Dependency[])NO_DEPENDENCIES);
    }

    LocalLoader getFallbackLoader() {
        return this.fallbackLoader;
    }

    void setDependencies(DependencySpec.SpecifiedDependency[] specifiedDependencies, boolean linkChildren) throws ModuleLoadException {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (DependencySpec.SpecifiedDependency specifiedDependency : specifiedDependencies) {
            dependencies.add(specifiedDependency.getDependency(this));
        }
        Dependency[] deps = dependencies.toArray(new Dependency[dependencies.size()]);
        if (linkChildren) {
            this.linkDependencies(new HashSet<Module>(), deps);
        }
        this.setDependencies(deps);
    }

    void setInitialDependencies(DependencySpec.SpecifiedDependency[] specifiedDependencies) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (DependencySpec.SpecifiedDependency specifiedDependency : specifiedDependencies) {
            dependencies.add(specifiedDependency.getDependency(this));
        }
        this.paths = new Paths(dependencies.toArray(new Dependency[dependencies.size()]), Collections.emptyMap(), Collections.emptyMap());
    }

    void linkInitial(HashSet<Module> visited) throws ModuleLoadException {
        if (this.loadState.compareTo(LoadState.LINKED) >= 0) {
            return;
        }
        this.link(visited);
    }

    void link(Set<Module> visited) throws ModuleLoadException {
        if (!visited.add(this)) {
            return;
        }
        this.resolveInitial();
        Dependency[] dependencies = (Dependency[])this.getDependencies().clone();
        this.linkDependencies(visited, dependencies);
    }

    private void linkDependencies(final Set<Module> visited, Dependency[] dependencies) throws ModuleLoadException {
        Collections.shuffle(Arrays.asList(dependencies));
        for (Dependency dependency : dependencies) {
            dependency.accept(new DependencyVisitor<Void>(){

                @Override
                public void visit(LocalDependency item, Void param) throws ModuleLoadException {
                }

                @Override
                public void visit(ModuleDependency item, Void param) throws ModuleLoadException {
                    Module module = item.getModuleRequired();
                    if (module != null) {
                        module.link(visited);
                    }
                }
            }, null);
        }
        for (Module module : visited) {
            module.loadState = LoadState.LINKED;
        }
    }

    ModuleClassLoader getClassLoaderPrivate() {
        return this.moduleClassLoader;
    }

    private static <K, V> void addToMapList(Map<K, List<V>> map, K key, V item) {
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        list.add(item);
    }

    public static Module getSystemModule() {
        return SystemModuleHolder.SYSTEM;
    }

    public final Resource getExportedResource(String rootPath, String resourcePath) {
        return this.moduleClassLoader.loadResourceLocal(rootPath, resourcePath, true);
    }

    final Resource getResource(String rootPath, String resourcePath) {
        return this.moduleClassLoader.loadResourceLocal(rootPath, resourcePath, false);
    }

    public final void run(String[] args) throws NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        try {
            if (this.mainClassName == null) {
                throw new NoSuchMethodException("No main class defined for " + this);
            }
            Class<?> mainClass = this.moduleClassLoader.loadClass(this.mainClassName);
            Method mainMethod = mainClass.getMethod("main", String[].class);
            int modifiers = mainMethod.getModifiers();
            if (!Modifier.isStatic(modifiers)) {
                throw new NoSuchMethodException("Main method is not static for " + this);
            }
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public <S> ServiceLoader<S> loadService(Class<S> serviceType) {
        return ServiceLoader.load(serviceType, this.moduleClassLoader);
    }

    public static <S> ServiceLoader<S> loadService(ModuleIdentifier moduleIdentifier, Class<S> serviceType) throws ModuleLoadException {
        return Module.getModule(moduleIdentifier).loadService(serviceType);
    }

    public static <S> ServiceLoader<S> loadService(String moduleIdentifier, Class<S> serviceType) throws ModuleLoadException {
        return Module.loadService(ModuleIdentifier.fromString(moduleIdentifier), serviceType);
    }

    public ModuleClassLoader getClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CLASS_LOADER);
        }
        return this.moduleClassLoader;
    }

    public Set<String> getExportedPaths() {
        return Collections.unmodifiableSet(this.paths.getExportedPaths().keySet());
    }

    public static Module forClass(Class<?> clazz) {
        ClassLoader cl = clazz.getClassLoader();
        return cl instanceof ModuleClassLoader ? ((ModuleClassLoader)cl).getModule() : (cl == null || cl == ClassLoader.getSystemClassLoader() ? Module.getSystemModule() : null);
    }

    public static Class<?> loadClass(ModuleIdentifier moduleIdentifier, String className, boolean initialize) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, initialize, ModuleClassLoader.forModule(moduleIdentifier));
    }

    public static Class<?> loadClass(ModuleIdentifier moduleIdentifier, String className) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, true, ModuleClassLoader.forModule(moduleIdentifier));
    }

    public static Class<?> loadClass(String moduleIdentifierString, String className, boolean initialize) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, initialize, ModuleClassLoader.forModule(ModuleIdentifier.fromString(moduleIdentifierString)));
    }

    public static Class<?> loadClass(String moduleIdentifierString, String className) throws ModuleLoadException, ClassNotFoundException {
        return Class.forName(className, true, ModuleClassLoader.forModule(ModuleIdentifier.fromString(moduleIdentifierString)));
    }

    public static Module getModule(ModuleIdentifier identifier) throws ModuleLoadException {
        return moduleLoaderSelector.getCurrentLoader().loadModule(identifier);
    }

    public static ModuleLoader getCurrentLoader() {
        return Module.getCurrentLoaderPrivate();
    }

    static ModuleLoader getCurrentLoaderPrivate() {
        return moduleLoaderSelector.getCurrentLoader();
    }

    Class<?> loadModuleClass(String className, boolean exportsOnly, boolean resolve) {
        LocalLoader fallbackLoader;
        if (className.startsWith("java.") || className.startsWith("sun.reflect.")) {
            try {
                return this.moduleClassLoader.loadClass(className, resolve);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        String path = Module.pathOfClass(className);
        Map<String, List<LocalLoader>> paths = this.paths.getPaths(exportsOnly);
        List<LocalLoader> loaders = paths.get(path);
        if (loaders != null) {
            Class<?> clazz = null;
            for (LocalLoader loader : loaders) {
                clazz = loader.loadClassLocal(className, resolve);
                if (clazz == null) continue;
                return clazz;
            }
        }
        if ((fallbackLoader = this.fallbackLoader) != null) {
            return fallbackLoader.loadClassLocal(className, resolve);
        }
        return null;
    }

    URL getResource(String name, boolean exportsOnly) {
        List<Resource> resourceList;
        Iterator<Resource> i$;
        LocalLoader fallbackLoader;
        if (name.startsWith("java/")) {
            return this.moduleClassLoader.getResource(name);
        }
        log.trace("Attempting to find resource %s in %s", (Object)name, (Object)this);
        String path = Module.pathOf(name);
        Map<String, List<LocalLoader>> paths = this.paths.getPaths(exportsOnly);
        List<LocalLoader> loaders = paths.get(path);
        if (loaders != null) {
            for (LocalLoader loader : loaders) {
                List<Resource> resourceList2 = loader.loadResourceLocal(name);
                Iterator<Resource> i$2 = resourceList2.iterator();
                if (!i$2.hasNext()) continue;
                Resource resource = i$2.next();
                return resource.getURL();
            }
        }
        if ((fallbackLoader = this.fallbackLoader) != null && (i$ = (resourceList = fallbackLoader.loadResourceLocal(name)).iterator()).hasNext()) {
            Resource resource = i$.next();
            return resource.getURL();
        }
        return null;
    }

    Enumeration<URL> getResources(String name, boolean exportsOnly) {
        LocalLoader fallbackLoader;
        if (name.startsWith("java/")) {
            try {
                return this.moduleClassLoader.getResources(name);
            }
            catch (IOException e) {
                return ConcurrentClassLoader.EMPTY_ENUMERATION;
            }
        }
        log.trace("Attempting to find all resources %s in %s", (Object)name, (Object)this);
        String path = Module.pathOf(name);
        Map<String, List<LocalLoader>> paths = this.paths.getPaths(exportsOnly);
        List<LocalLoader> loaders = paths.get(path);
        ArrayList<URL> list = new ArrayList<URL>();
        if (loaders != null) {
            for (LocalLoader loader : loaders) {
                List<Resource> resourceList = loader.loadResourceLocal(name);
                for (Resource resource : resourceList) {
                    list.add(resource.getURL());
                }
            }
        }
        if ((fallbackLoader = this.fallbackLoader) != null) {
            List<Resource> resourceList = fallbackLoader.loadResourceLocal(name);
            for (Resource resource : resourceList) {
                list.add(resource.getURL());
            }
        }
        return list.size() == 0 ? ConcurrentClassLoader.EMPTY_ENUMERATION : Collections.enumeration(list);
    }

    public final URL getExportedResource(String name) {
        return this.getResource(name, true);
    }

    public Enumeration<URL> getExportedResources(String name) {
        return this.getResources(name, true);
    }

    static String pathOfClass(String className) {
        String resourceName = className.replace('.', '/');
        int idx = resourceName.lastIndexOf(47);
        String path = idx > -1 ? resourceName.substring(0, idx) : "";
        return path;
    }

    static String pathOf(String resourceName) {
        if (resourceName.indexOf(47) == 0) {
            return Module.pathOf(resourceName.substring(1));
        }
        int idx = resourceName.lastIndexOf(47);
        String path = idx > -1 ? resourceName.substring(0, idx) : "";
        return path;
    }

    static String fileNameOfClass(String className) {
        return className.replace('.', '/') + ".class";
    }

    public String toString() {
        return "Module \"" + this.identifier + "\"";
    }

    public static void setModuleLoaderSelector(ModuleLoaderSelector moduleLoaderSelector) {
        if (moduleLoaderSelector == null) {
            throw new IllegalArgumentException("moduleLoaderSelector is null");
        }
        Module.moduleLoaderSelector = moduleLoaderSelector;
    }

    public static void setModuleLogger(ModuleLogger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        logger.greeting();
        log = logger;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    URL.setURLStreamHandlerFactory(new ModularURLStreamHandlerFactory());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return null;
            }
        });
        log = NoopModuleLogger.getInstance();
        moduleLoaderSelector = ModuleLoaderSelector.DEFAULT;
        NO_DEPENDENCIES = new Dependency[0];
        pathsUpdater = Module.unsafeCast(AtomicReferenceFieldUpdater.newUpdater(Module.class, Paths.class, "paths"));
        loadStateUpdater = AtomicReferenceFieldUpdater.newUpdater(Module.class, LoadState.class, "loadState");
        GET_CLASS_LOADER = new RuntimePermission("getClassLoader");
    }

    private static final class SystemModuleHolder {
        private static final Module SYSTEM;

        private SystemModuleHolder() {
        }

        static {
            SystemLocalLoader systemLocalLoader = SystemLocalLoader.getInstance();
            LocalDependency localDependency = new LocalDependency(PathFilters.acceptAll(), PathFilters.acceptAll(), systemLocalLoader, systemLocalLoader.getPathSet());
            Module system = new Module();
            system.getClassLoaderPrivate().recalculate();
            try {
                system.setDependencies(new DependencySpec.SpecifiedDependency[]{new DependencySpec.ImmediateSpecifiedDependency(localDependency)}, false);
            }
            catch (ModuleLoadException e) {
                throw new Error("Failed to initialize system module", e);
            }
            SYSTEM = system;
        }
    }

    static final class DependencyImport {
        private final Module module;
        private final boolean export;

        DependencyImport(Module module, boolean export) {
            this.module = module;
            this.export = export;
        }

        Module getModule() {
            return this.module;
        }

        ModuleClassLoader getClassLoader() {
            return this.module.getClassLoader();
        }

        boolean isExport() {
            return this.export;
        }
    }

    static enum LoadState {
        LOADED,
        RESOLVED,
        LINKED;

    }
}

