/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.concurrent.ConcurrentMap;
import org.jboss.modules.ConcurrentReferenceHashMap;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleAlreadyExistsException;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLogger;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.modules.ModuleSpec;

public abstract class ModuleLoader {
    private final ConcurrentMap<ModuleIdentifier, FutureModule> moduleMap = new ConcurrentReferenceHashMap<ModuleIdentifier, FutureModule>(256, 0.5f, 32, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK, EnumSet.noneOf(ConcurrentReferenceHashMap.Option.class));

    protected ModuleLoader() {
    }

    public final Module loadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        Module module = this.preloadModule(identifier);
        module.linkInitial(new HashSet<Module>());
        return module;
    }

    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        Module module = this.loadModuleLocal(identifier);
        if (module == null) {
            throw new ModuleNotFoundException(identifier.toString());
        }
        return module;
    }

    protected static Module preloadModule(ModuleIdentifier identifier, ModuleLoader moduleLoader) throws ModuleLoadException {
        return moduleLoader.preloadModule(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Module loadModuleLocal(ModuleIdentifier identifier) throws ModuleLoadException {
        if (identifier.equals(ModuleIdentifier.SYSTEM)) {
            return Module.getSystemModule();
        }
        FutureModule futureModule = (FutureModule)this.moduleMap.get(identifier);
        if (futureModule != null) {
            return futureModule.getModule();
        }
        FutureModule newFuture = new FutureModule(identifier);
        futureModule = this.moduleMap.putIfAbsent(identifier, newFuture);
        if (futureModule != null) {
            return futureModule.getModule();
        }
        boolean ok = false;
        try {
            ModuleLogger log = Module.log;
            log.trace("Locally loading module %s from %s", (Object)identifier, (Object)this);
            ModuleSpec moduleSpec = this.findModule(identifier);
            if (moduleSpec == null) {
                log.trace("Module %s not found from %s", (Object)identifier, (Object)this);
                Module module = null;
                return module;
            }
            if (!moduleSpec.getModuleIdentifier().equals(identifier)) {
                throw new ModuleLoadException("Module loader found a module with the wrong name");
            }
            Module module = this.defineModule(moduleSpec);
            log.trace("Loaded module %s from %s", (Object)identifier, (Object)this);
            ok = true;
            Module module2 = module;
            return module2;
        }
        finally {
            if (!ok) {
                newFuture.setModule(null);
                this.moduleMap.remove(identifier, newFuture);
            }
        }
    }

    protected abstract ModuleSpec findModule(ModuleIdentifier var1) throws ModuleLoadException;

    private Module defineModule(ModuleSpec moduleSpec) throws ModuleLoadException {
        ModuleLogger log = Module.log;
        ModuleIdentifier moduleIdentifier = moduleSpec.getModuleIdentifier();
        FutureModule futureModule = (FutureModule)this.moduleMap.get(moduleIdentifier);
        if (futureModule == null) {
            throw new IllegalStateException("Attempted to define a module from outside loadModuleLocal");
        }
        Module module = new Module(moduleSpec, this, futureModule);
        try {
            futureModule.setModule(module);
            return module;
        }
        catch (ModuleLoadException e) {
            log.trace((Throwable)e, "Failed to load module %s", (Object)moduleIdentifier);
            throw e;
        }
        catch (RuntimeException e) {
            log.trace((Throwable)e, "Failed to load module %s", (Object)moduleIdentifier);
            throw e;
        }
        catch (Error e) {
            log.trace((Throwable)e, "Failed to load module %s", (Object)moduleIdentifier);
            throw e;
        }
    }

    private static final class FutureModule {
        private static final Object NOT_FOUND = new Object();
        private final ModuleIdentifier identifier;
        private volatile Object module;

        FutureModule(ModuleIdentifier identifier) {
            this.identifier = identifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Module getModule() throws ModuleNotFoundException {
            boolean intr = false;
            try {
                Object object;
                Object module = this.module;
                if (module == null) {
                    object = this;
                    synchronized (object) {
                        while ((module = this.module) == null) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                intr = true;
                            }
                        }
                    }
                }
                if (module == NOT_FOUND) {
                    throw new ModuleNotFoundException(this.identifier.toString());
                }
                object = (Module)module;
                return object;
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setModule(Module m) throws ModuleAlreadyExistsException {
            FutureModule futureModule = this;
            synchronized (futureModule) {
                this.module = m == null ? NOT_FOUND : m;
                this.notifyAll();
            }
        }
    }
}

